/**
 * Copyright techx ( http://wonderfl.net/user/techx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zdNR
 */

// forked from okoi's ColorBalls
//
//    クリックでカラーボール発射
//    
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import frocessing.color.ColorHSV;
    
    /**
     * @author 
     */
    public class Main extends Sprite 
    {
        private var balls:/*Ball*/Array = new Array();
        private var click:Boolean = false;
        private    var canvas:BitmapData;
        
        private    var rcount:int = 0;
        private var color:ColorHSV = new ColorHSV();

        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            canvas = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0xFF000000 );
            addChild( new Bitmap( canvas ) );
            
            stage.addEventListener( MouseEvent.MOUSE_DOWN, MouseDown );
            stage.addEventListener( MouseEvent.MOUSE_UP, MouseUp );
            addEventListener( Event.ENTER_FRAME, Update );
            
        }
        private function     MouseDown(e:MouseEvent):void 
        {
            click = true;
        }
        private    function    MouseUp( e:MouseEvent ) : void
        {
            click = false;
        }        
        
        
        private    function    Shoot() : void
        {
            for ( var i:int = 0; i < 4; i++ )
            {
                var angle:Number = (rcount + i * 90) % 360;
                var cos:Number = Math.cos( angle * Math.PI / 180 );
                var sin:Number = Math.sin( angle * Math.PI / 180 );
                balls[ balls.length ] = new Ball( 
                    stage.mouseX, stage.mouseY, 
                    10,
                    color.value,
                    cos * 250 + stage.stageWidth / 2,
                    sin * 250 + stage.stageHeight/2 );
            }
        }
        
        private    function    Update(e:Event) : void
        {
            if ( click )
            {
                Shoot();
            }    
            
            canvas.lock();
            var num:uint = balls.length;
            for ( var i:int = num - 1; i >= 0; i-- )
            {
                balls[i].Update();
                balls[i].Draw( canvas );
                
                if ( balls[i].x + balls[i].size / 2 < 0 ||
                     balls[i].x - balls[i].size / 2 > stage.stageWidth ||
                     balls[i].y + balls[i].size / 2 < 0 ||
                     balls[i].y - balls[i].size / 2 > stage.stageHeight )
                     {
                         balls.splice( i, 1 );
                     }
            }
            canvas.unlock();
            
            rcount = (rcount+3) % 360;
            color.h = rcount;
        }

        
    }
    
}
import flash.display.Shape;
import flash.display.BitmapData;
import flash.geom.Matrix;

class Ball {
    private    var shape:Shape;
    private var _x:Number;
    public    function get x():Number { return    _x;    }
    public    function get y():Number { return    _y;    }
    private var _y:Number;
    
    private var _mx:Number = 0;
    private var _my:Number = 0;
    
    private var _size:int;
    public    function get size():int { return    _size;    }
    
    public    function    Ball( __x:Number, __y:Number, __size:int, color:uint, tx:Number, ty:Number ) 
    {
        _x = __x;
        _y = __y;
        _size = __size;

        shape = new Shape();
        
        shape.graphics.beginFill( color );
        shape.graphics.lineStyle( 4, 0x0 );
        shape.graphics.drawCircle( 0, 0, 8 );
        shape.graphics.endFill();
        
        var len:Number = Math.sqrt( (tx - _x) * (tx - _x) + (ty - _y) * (ty - _y) );
        _mx = (tx - _x) / len * 10;
        _my = (ty - _y) / len * 10;        
    }
    
    public    function    Update() : void
    {
        _x += _mx;
        _y += _my;
    }
    
    public    function    Draw( canvas:BitmapData ) : void
    {
        //canvas.draw( shape, new Matrix( 1, 0, 0, 1, _x, _y ) );
        canvas.draw( shape, new Matrix( 1, 0, 0, 1, _x, _y ) );
        canvas.draw( shape, new Matrix( 1, 0, 0, 1, _x+200, _y ) );
        //canvas.draw( shape, new Matrix( 1, 0, 0, 1, _x, _y+200 ) );
        canvas.draw( shape, new Matrix( 1, 0, 0, 1, _x+100, _y+200 ) );
    }
}