/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zdAY
 */

// Change the color of a BlinkM with a potentiometer
// 
// Preparation:
// * Connect a potentiometer to A0
// * Connect a BlinkM to A4/A5
// 
// Reference:
// http://thingm.com/products/blinkm
// 
// Where to buy:
// http://www.sparkfun.com/commerce/product_info.php?products_id=8579
// http://www.switch-science.com/products/detail.php?product_id=32

package {
    import flash.display.Sprite;

    import funnel.*;
    import funnel.gui.*;
    import funnel.i2c.*;

    public class ArduinoI2CBlinkM extends Sprite {
        private var arduino:Arduino;
        private var blinkM:BlinkM;
        private var potPin:Pin;

        public function ArduinoI2CBlinkM() {
            var config:Configuration = Arduino.FIRMATA;
            arduino = new Arduino(config);
            arduino.addEventListener(FunnelEvent.READY, onReady);

            var gui:ArduinoGUI = new ArduinoGUI();
            addChild(gui);
            arduino.gui = gui;
        }

        private function onReady(event:FunnelEvent):void {
            blinkM = new BlinkM(arduino);
            blinkM.stopScript();
            blinkM.goToRGBColorNow([0, 0, 0]);

            potPin = arduino.analogPin(0);
            potPin.addEventListener(CHANGE, onPotPinChange);
        }

        private function onPotPinChange(e:PinEvent):void {
            blinkM.fadeToHSBColor([potPin.value * 255, 255, 255], 255);
        }
    }
}