/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zcEX
 */

// forked from clockmaker's あなたのイベントハンドラを教えて！
/**
* あなたのイベントハンドラを教えて！
*
* 複数のイベント＆複数のインスタンスに
* イベントハンドラを設定するときに
* みなさんの記述方法の違いを知りたい。
*
* [ルール]
* 画面上に3つのボタンが用意されており、
* クリックとロールオーバーの
* イベントハンドラを記述してください。
*/
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.core.easing.BackEaseInOut;
	import org.libspark.betweenas3.core.easing.CircularEaseInOut;
	import org.libspark.betweenas3.core.easing.ElasticEaseInOut;
	import org.libspark.betweenas3.tweens.ITween;
    public class FlashTest extends Sprite {
    
        private var _btnA:MyButton;
        private var _btnB:MyButton;
        private var _btnC:MyButton;
        private var _label:MyTextField;
		private var isReverse: Boolean;

        public function FlashTest() {
            // ボタンを作成
            _build();
            
            // ClockMaker 流
            // クリック
            _btnA.addEventListener(MouseEvent.CLICK, onClickBtn);
            _btnB.addEventListener(MouseEvent.CLICK, onClickBtn);
            _btnC.addEventListener(MouseEvent.CLICK, onClickBtn);
            // ロールオーバー
            _btnA.addEventListener(MouseEvent.ROLL_OVER, onRollOverBtn);
            _btnB.addEventListener(MouseEvent.ROLL_OVER, onRollOverBtn);
            _btnC.addEventListener(MouseEvent.ROLL_OVER, onRollOverBtn);
        }
		
		private function onRollOverBtn(e:MouseEvent):void 
		{
			var myBtn: MyButton = MyButton(e.target);
			var tw: ITween = myBtn.tag;
			isReverse ? BetweenAS3.reverse(tw).play() : tw.play();
			isReverse = !isReverse;
			_label.text = myBtn.text + " がロールオーバーされました";
		}
		
		private function onClickBtn(e:MouseEvent):void 
		{
			var myBtn: MyButton = MyButton(e.target);
			var tw: ITween = myBtn.tag;
			isReverse ? BetweenAS3.reverse(tw).play() : tw.play();
			isReverse = !isReverse;
			_label.text = myBtn.text + " がクリックされました";
		}
        
        /**
        * インターフェースを作る
        */
        private function _build():void 
		{
            _label = new MyTextField();
            _label.x = 150; _label.y = 280;
            addChild(_label);
			
            _btnA = new MyButton();
            _btnA.text = "Button A"; 
            _btnA.x = 70; _btnA.y = 230;
            addChild(_btnA);
            
            _btnB = new MyButton();
            _btnB.text = "Button B";
            _btnB.x = 190; _btnB.y = 230;
            addChild(_btnB);
   
            _btnC = new MyButton();            
            _btnC.text = "Button C";
            _btnC.x = 310; _btnC.y = 230;
            addChild(_btnC);
			
			_btnA.tag = BetweenAS3.tween(_label, { y: 280 }, { y: 400 }, 1, new BackEaseInOut());
			_btnB.tag = BetweenAS3.tween(_label, { y: 280 }, { y: 400 }, 1, new ElasticEaseInOut());
			_btnC.tag = BetweenAS3.tween(_label, { y: 280 }, { y: 400 }, 1, new CircularEaseInOut());
        }
    }
}

import flash.display.*
import flash.text.*;

/**
* MyButton クラスはボタン的な挙動をするようにしたSpriteです。
*/
class MyButton extends Sprite {
	public var tag: *;
    private var _text:MyTextField;
    /**
    * 新しい MyButton インスタンスを作成します。
    */
    public function MyButton(){
        graphics.beginFill(0x000000);
        graphics.drawRoundRect(0, 0, 100, 30, 5, 5);
        addChild(_text = new MyTextField);
        buttonMode = true;
    }
    /**
    * ボタンの文言を設定します。
    */
    public function set text(value:String):void {
        _text.text = value;
        _text.x = (100 - _text.textWidth) / 2;
        _text.y = (30 - _text.textHeight) / 2;
    }
	
	public function get text(): String { return _text.text; }
}

/**
* MyTextField クラスは適当な初期設定をしただけのテキストフィールドです。
*/
class MyTextField extends TextField {
    /**
    * 新しい MyTextField インスタンスを作成します。
    */
    public function MyTextField() {
        defaultTextFormat = new TextFormat("_sans", 12, 0xFF0000);
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
    }
}