/**
 * Copyright hashito ( http://wonderfl.net/user/hashito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zcAJ
 */

// MainStage
package {
	import flash.display.Sprite;
	[SWF(frameRate=60,width=456,height=456)]
	public class MainStage extends Sprite {
		public function MainStage(){
			addChild(new Main());
		}
	}
}

import flash.display.*;
import flash.filters.BlurFilter;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.events.*;
import flash.text.TextField;
import net.hires.debug.Stats;

//class debug{public static var out:TextField=new TextField();}

//
class Main extends Sprite{
	public const H:Number = 456;
	public const W:Number = 456;
	private var m:Map = new Map(W,H);
	//Constructor
	public function Main() {addEventListener(Event.ADDED_TO_STAGE, init);}
	//init
	public function init(e:*):void{
		addChild(m);
		m.addBranch(new Branch(m,W/2,H/2, W/2, H/2, 2000));
		// debug
		//debug.out.autoSize=flash.text.TextFieldAutoSize.LEFT;
		//addChild(debug.out);
		//debug.out.text="0";
		m.addEventListener(Event.ENTER_FRAME ,update);
		stage.addEventListener(MouseEvent.MOUSE_DOWN ,reset);
	}
	public function update(e:Event=null):void{
		m.update();
		//m.addBranch(new Branch(m,mouseX,mouseY, W/2, H/2, 2000));
	}
	public function reset(e:MouseEvent=null):void{
		m.addBranch(new Branch(m,mouseX,mouseY, W/2, H/2, 2000));
	}
}
class Map extends Bitmap{
	private var board:Sprite=new Sprite()
	public var w:int,h:int;
	private const MAX_BRANCH:int = 30;
	public function Map(w:int,h:int){
		this.w=w;this.h=h;
		this.bitmapData = new BitmapData(w,h,false,0x0);
	}
	// board mg
	public function addBranch(b:Branch):void{
	if(MAX_BRANCH>board.numChildren)board.addChild(b);}
	public function removeBranch(b:Branch):void{board.removeChild(b);}

	public var filter:BlurFilter=new BlurFilter(1.01,1.01);
	public var colortf:ColorTransform =new ColorTransform(0.992,0.992,0.992);
	public function update():void{
		var b:BitmapData=this.bitmapData;
		for(var i:int = 0; i < board.numChildren ;i++)
			Branch(board.getChildAt(i)).update();
		b.draw(board);
		b.colorTransform( b.rect, colortf);
		b.applyFilter(b,b.rect,new Point(),filter);
	}
}
class Branch extends Shape{
	private var p:int;
	private var vx:Number,vy:Number,map:Map,ex:int,ey:int;
	private const K:int=2;
	public function Branch(map:Map,sx:int,sy:int,ex:int,ey:int,p:int){
		this.p = p;this.map=map;this.ex=ex;this.ey=ey;
		this.x=sx;
		this.y=sy;
		this.vx = ispm(ex-sx) * Math.random()*K  - 0.5*K;
		this.vy = ispm(ey-sy) * Math.random()*K  - 0.5*K;
		function ispm(x:Number):Number{if(x>0){return 1;}else if(x<0){return -1}return 0;}
		
		this.graphics.beginFill(0x00ffff);
		this.graphics.drawCircle(0,0,1*K);
		this.graphics.endFill();
	}
	public function update():void{
		if(Math.random() > 0.05){
			x+=vx;y+=vy;
		}else{
			var max:int = Math.floor(Math.random()*4)+1;
			var pp:int;
			for(var i:int = 0 ; i < max ; i++ ){
				pp = p * Math.random();
				map.addBranch(new Branch(map,x,y,ex,ey,Math.random()*100/K));
			}
			map.removeBranch(this);
		}
		if( ( x==ex && y==ey )||( p <= 0 ))
			map.removeBranch(this);
		p--;
	}
}
