/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zbuz
 */

package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.events.MouseEvent;
	import flash.filters.DropShadowFilter;
	
	public class Main extends Sprite
	{
		private var circleA:Circle;
		private var circleB:Circle;
		private var textA:Bitmap;
		private var textB:Bitmap;
		private var textC:Bitmap;
		
		public function Main()
		{
			circleA = new Circle(0xED1A3D);
			circleA.x = circleA.y = 100;
			addChild(circleA);
			
			circleB = new Circle(0x009AD6);
			circleB.x = circleB.y = 200;
			addChild(circleB);
			
			circleA.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			circleB.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			circleA.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			circleB.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			
			onMouseMove();
		}
		
		private function onMouseDown(event:MouseEvent):void
		{
			var circle:Circle = event.currentTarget as Circle;
			circle.startDrag();
			
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
		
		private function onMouseMove(event:MouseEvent = null):void
		{
			graphics.clear();
			graphics.lineStyle(1.0, 0x0);
			graphics.moveTo(circleA.x, circleA.y);
			graphics.lineTo(circleB.x, circleB.y);
			
			graphics.lineStyle(1.0, 0x999999);
			graphics.moveTo(circleA.x, circleA.y);
			graphics.lineTo(circleB.x, circleA.y);
			graphics.lineTo(circleB.x, circleB.y);
			
			const SIZE:int = 12;
			var tx:int = (circleA.x > circleB.x) ? SIZE : -SIZE;
			var ty:int = (circleA.y > circleB.y) ? -SIZE : SIZE;
			
			graphics.moveTo(circleB.x + tx, circleA.y);
			graphics.lineTo(circleB.x + tx, circleA.y + ty);
			graphics.lineTo(circleB.x, circleA.y + ty);
			
			if (textA) removeChild(textA);
			textA = Text.textToBitmap(Text.createTextField(Math.abs(circleA.x - circleB.x).toString(), 17), true, 0x0);
			textA.x = circleB.x - (circleB.x - circleA.x) / 2 - textA.width / 2;
			textA.y = circleA.y - textA.height / 2;
			addChild(textA);
			
			if (textB) removeChild(textB);
			textB = Text.textToBitmap(Text.createTextField(Math.abs(circleA.y - circleB.y).toString(), 17), true, 0x0);
			textB.x = circleB.x - textB.width / 2;
			textB.y = circleB.y - (circleB.y - circleA.y) / 2 - textB.height / 2;
			addChild(textB);
			
			if (textC) removeChild(textC);
			textC = Text.textToBitmap(Text.createTextField(int(Math.sqrt(Math.pow(circleA.x - circleB.x, 2) + Math.pow(circleA.y - circleB.y, 2))).toString(), 17), true, 0x0);
			textC.x = circleB.x - (circleB.x - circleA.x) / 2 - textC.width / 2;
			textC.y = circleB.y - (circleB.y - circleA.y) / 2 - textC.height / 2;
			addChild(textC);
		}
	
		private function onMouseUp(event:MouseEvent):void
		{
			var circle:Circle = event.currentTarget as Circle;
			circle.stopDrag();
			
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}

import flash.display.Sprite;
import flash.filters.BevelFilter;
import flash.filters.DropShadowFilter;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.filters.GlowFilter;
import flash.text.TextField;
import flash.text.TextFormat;
 
class Text
{
	public static function createTextField(text:String, size:int, color:int = 0xFFFFFF):TextField
	{
		var tf:TextField = new TextField();
		tf.defaultTextFormat = new TextFormat("_typeWriter", size, color, true);
		tf.text = text;
		tf.autoSize = "left";
		tf.selectable = false;
 
		return tf;
	}
 
	public static function textToBitmap(tf:TextField, transparent:Boolean = true ,cc:uint = 0xFF0000):Bitmap
	{
		var bd:BitmapData = new BitmapData(tf.width, tf.height, transparent, 0x0);
		bd.draw(tf);
 
		var bitmap:Bitmap = new Bitmap(bd);
		bitmap.filters = [new GlowFilter(cc, 1, 4, 4, 15)];
		return bitmap;
	}
}

class Circle extends Sprite
{	
	public function Circle(color:int)
	{
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, 10);
		graphics.endFill();
		
		this.filters = [new DropShadowFilter(2), new BevelFilter(4, 45, 0xF0F0F0, 1, 0x0, 1, 2, 2, 5)];
	}
}