/**
 * Copyright royi ( http://wonderfl.net/user/royi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zazm
 */

package {
    import flash.ui.Mouse;
    import flash.events.MouseEvent;
    import flash.display.Graphics;
    import flash.utils.ByteArray;
    import flash.media.Sound;
    import flash.media.SoundMixer;
    import flash.events.Event;
    import flash.events.SampleDataEvent;
    import flash.display.Sprite;
    
    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]
    public class Main extends Sprite {
        private static const SAMPLE_RATE:int = 44100;
        private static const SAMPLE_TIME:Number = 1 / 44100;
        private static const BUFFER:int = 3072;
        
        private var sound:Sound = new Sound();
        private var sine:Vector.<Number> = new Vector.<Number>(SAMPLE_RATE);
        private var freq:Number = 440;
        private var amplitude:Number = .5;
        private var soundPos:Number = 0;
        
        private var cursorVisible:Boolean = false;
        
        private var bytes:ByteArray = new ByteArray();
        
        private var sw:int, sh:int;
        private var centerX:int, centerY:int;
        
        public function Main() {
            sw = stage.stageWidth, sh = stage.stageHeight;
            centerX = sw / 2;
            centerY = sh / 2;
            
            Mouse.hide();
            
            var pos:Number = 0;
            for (var i:int = 0; i < SAMPLE_RATE; i++) {
                pos = i / SAMPLE_RATE;
                sine[i] = Math.sin(Math.PI * 2 * pos);
            }
            
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onSampleData);
            sound.play();
            
            addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(Event.MOUSE_LEAVE, onMouseLeave);
        }
        
        private function onMouseMove(e:MouseEvent):void {
            cursorVisible = true;
            freq = sh - mouseY;
            amplitude = mouseX / sw;
        }
        
        private function onMouseLeave(e:Event):void {
            cursorVisible = false;
        }
        
        private function loop(e:Event):void {
            var g:Graphics = this.graphics;
            g.clear();
            g.beginFill(0x777777);
            g.drawRect(0, 0, 465, 465);
            g.endFill();
            
            SoundMixer.computeSpectrum(bytes, false, 0);
            
            g.lineStyle(0, 0x999999);
            var channelLength:int = 256;
            var plotHeight:int = centerY;
            var ratio:Number = sw / channelLength;
            var n:Number = 0;
            for (var i:int = 0; i < channelLength; i++) {
                n = bytes.readFloat() * plotHeight;
                
                g.moveTo(i * ratio, centerY);
                g.lineTo(i * ratio, centerY - n);
            }
            
            if (cursorVisible) {
                var cursorSize:int = 20;
                g.moveTo(mouseX - cursorSize, mouseY);
                g.lineTo(mouseX + cursorSize,  mouseY);
                g.moveTo(mouseX, mouseY - cursorSize);
                g.lineTo(mouseX, mouseY + cursorSize);
            }
        }
        
        private function onSampleData(e:SampleDataEvent):void {
            var pos:int;
            var sample:Number;
            for (var i:int = 0; i < BUFFER; i++) {
                pos = (SAMPLE_RATE * freq * soundPos) % SAMPLE_RATE;
                sample = sine[pos] * amplitude;
                e.data.writeFloat(sample);
                e.data.writeFloat(sample);
                soundPos += SAMPLE_TIME;
            }
        }
    }
}