/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zag4
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    
    /**
     * ...
     * @author Greek Fellows
     */
    public class Main extends Sprite 
    {
        private var sprite:Sprite;
        private var core:Sprite;
        private var array:Array;
        private var colors:Array;
        private var radii:Array;
        private var zsorted:Array;
        
        public function Main():void 
        {
            this.array = [];
            this.colors = [];
            this.radii = [];
            this.zsorted = [];
            
            init();
            
            this.sprite=new Sprite();
            this.sprite.x=465/2;
            this.sprite.y=465/2;
            this.sprite.z=0;
            this.addChild(this.sprite);
            
            this.core=new Sprite();
            this.core.x=0;
            this.core.y=0;
            this.core.z=0;
            this.sprite.addChild(this.core);
            
            this.addEventListener(Event.ENTER_FRAME,spin);
        }
        
        private function init():void {
            // change array here
            this.array = [new Vector3D(100, 100, 100), new Vector3D(-100, 100, 100), new Vector3D(-100, -100, 100), new Vector3D(100, -100, 100), new Vector3D(100, 100, -100), new Vector3D(-100, 100, -100), new Vector3D(-100, -100, -100), new Vector3D(100, -100, -100)];
            
            for (var a:int = 0; a < array.length; a++) {
                var vector:Vector3D = this.array[a];
                this.array[a] = { vector:vector, color:Math.floor(Math.random() * 0xffffff / 5) * 5, radius:Math.random() * 45 + 5 };
            }
        }
        
        private function graph(vector:Vector3D,transformVector:Boolean=true):Vector3D {
            var mat:Matrix3D = this.core.transform.matrix3D.clone();
            
            var xy:Vector3D = vector;
            if (transformVector) xy = mat.transformVector(vector);
            xy.w = (750 + xy.z) / 750;
            xy.project();
            
            return xy;
        }
        
        private    function spin(e:Event):void {
            this.core.transform.matrix3D.appendRotation((mouseY - 200) / 50, Vector3D.X_AXIS);
            this.core.transform.matrix3D.appendRotation((mouseX - 300) / 50, Vector3D.Y_AXIS);
            
            this.sprite.graphics.clear();
            
            sortbyZ();
            
            for (var b:int = 0; b < this.zsorted.length; b++) {
                this.sprite.graphics.beginFill(this.zsorted[b].color, 1);
                this.sprite.graphics.drawCircle(graph(this.zsorted[b].vector,false).x, graph(this.zsorted[b].vector,false).y, this.zsorted[b].radius);
                this.sprite.graphics.endFill();
            }
        }
        
        private function sortbyZ():void {
            this.zsorted = [];
            var mat:Matrix3D = this.core.transform.matrix3D.clone();
            
            for (var c:int = 0; c < this.array.length; c++) {
                this.zsorted.push( { vector:mat.transformVector(this.array[c].vector), color:this.array[c].color, radius:this.array[c].radius, z:mat.transformVector(this.array[c].vector).z } );
            }
            
            this.zsorted.sortOn("z", Array.NUMERIC | Array.DESCENDING);
        }
        
    }
    
}