/**
 * Copyright shevchenko ( http://wonderfl.net/user/shevchenko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zZfX
 */

package
{
    import flash.display.StageQuality;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.utils.Timer;
    import org.papervision3d.materials.BitmapViewportMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.MovieMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.view.BitmapViewport3D;
    
    
    import flash.events.*;
    import flash.filters.*;
    import flash.utils.*;
    import org.papervision3d.core.effects.view.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.primitives.*;
    
    import org.papervision3d.view.BasicView;

    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;

    import caurina.transitions.Tweener;
    
    //import com.mrdoob.utils.Debugger;
    
    [SWF( backgroundColor='0xFFFFFF', frameRate='30', width='465', height='465')]
    
    public class clock extends ReflectionView 
    {
        
        //public var scene    :Scene3D;
        //public var renderer:BasicRenderEngine;
        
        //public var camera:Camera3D;
        //public var camera_shadow:Camera3D;        
        
    //    public var viewport:Viewport3D;
        public var viewport_shadow:BitmapViewport3D;
        
        private var cube:Cube;
        
    //    public var floor    :Plane;
        //public var floor_texture:BitmapViewportMaterial;
        
        public var white    :ColorMaterial;
        public var black    :ColorMaterial;
        //public var shadowMat:BitmapViewportMaterial;
        
        public var chars:Array;
        
        
        public function clock()
        {
            var material:FlatShadeMaterial = new FlatShadeMaterial(new PointLight3D(), 0x2288CC, 0x004466);
            var materials:MaterialsList = new MaterialsList( { all:material } );
            
            stage.quality = StageQuality.HIGH;
            //stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;            
            
            chars = new Array();

            chars[0] = [ 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1 ];
            chars[1] = [ 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1 ];
            chars[2] = [ 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1 ];
            chars[3] = [ 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1 ];
            chars[4] = [ 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1 ];
            chars[5] = [ 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1 ];
            chars[6] = [ 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1 ];
            chars[7] = [ 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0 ];
            chars[8] = [ 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1 ];
            chars[9] = [ 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1 ];
            chars[10] = [ 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0 ];            
            
            init();
            //init3D();
            sceneSetup();
            
            var myTimer:Timer = new Timer(1000);
            
            myTimer.addEventListener( "timer", updateClock );
            myTimer.start();
            
            //cube = new Cube(materials);
            //scene.addChild(cube);
            camera.focus=400;
            camera.zoom=1;
             //camera.x=100;
             
                        // 反射を設定
            surfaceHeight = -30; // 反射面の座標
            
            viewportReflection.filters = [new BlurFilter(8, 8, 3)]; 
            viewportReflection.alpha = 0.7; // 反射面の透明度
            
            addEventListener(Event.ENTER_FRAME,loop);
        }
        
        public function init():void
        {
            //Debugger.setup(this,{fps:true,tracer:true});
        }
        
                
        public function sceneSetup():void
        {
            
            var material:FlatShadeMaterial = new FlatShadeMaterial(new PointLight3D(), 0x2288CC, 0x004466);
            var materials:MaterialsList = new MaterialsList( { all:material } );
            
            black = new ColorMaterial(0x000000);
            white = new ColorMaterial(0xFFFFFF);
            //shadowMat = new BitmapViewportMaterial(viewport_shadow);
            
            var clock3D:DisplayObject3D = new DisplayObject3D();
            clock3D.name = "clock";
            
            for (var i:Number = 0; i < 8; i++)
            {
                var char3D:DisplayObject3D = new DisplayObject3D();
                char3D.name = "char" + i;
                
                var zpos:Number = -1;
                
                if (i == 2 || i == 5)
                {
                    var dot:Cube =  new Cube(new MaterialsList({ all:material }),100,100,100,1,1,1);
                    dot.x = 100;
                    
                    dot.z = -100;
                    dot.name = "dot"+0;
                    char3D.addChild(dot);
                    
                    dot = new Cube(new MaterialsList({ all:material }),100,100,100,1,1,1);
                    dot.x = 100;
                    dot.z = -300;
                    dot.name = "dot"+1;
                    char3D.addChild(dot);
                }
                else
                {
                    for (var c:Number = 0; c < 15; c ++)
                    {
                        dot = new Cube(new MaterialsList({ all:material }),100,100,100,1,1,1);
                        
                        if ((c % 3) == 0)
                            zpos ++;
                        
                        dot.x = (c % 3) * 100;
                        dot.z = -zpos * 100;
                        
                        dot.extra = { x:dot.x, y:dot.y, z:dot.z };
                        
                        dot.name = "dot"+c;
                        char3D.addChild(dot);
                    }                
                }
                
                char3D.x = i * 350;
                clock3D.addChild(char3D);
                
            }
            
            clock3D.x = -250;
            
            clock3D.z = 990;
            
            clock3D.y = 50;
            
            scene.addChild(clock3D);
            camera.target=clock3D;
            
            //floor = new Plane(white,5120,2560,10,10)
            //floor.y = -200;
            //floor.pitch(90);
            
            
            //scene.addChild(floor);
            
        }
        
        
        // .. CLOCK FUNCTIONS ................................................................................................

        
        public function doubleDigitFormat(num:uint):String
        {
            if(num < 10)
                return (String("0" + num));
                
            return String(num);
        }

        
        public function updateChar3D(i:Number,char:String):void
        {
            var char3D:DisplayObject3D = scene.getChildByName("clock").getChildByName("char"+i);
            
            var rand:Number = Number(char)*50; //Math.random()*500;
            
            if (Number(char) == 10)
            {
                char3D.getChildByName("dot"+0).scale = 0;
                char3D.getChildByName("dot"+1).scale = 0;        
                Tweener.addTween(char3D.getChildByName("dot"+0),{scale:1,time:1,transition:"easeOutExpo"});
                Tweener.addTween(char3D.getChildByName("dot"+1),{scale:1,time:1,transition:"easeOutExpo"});
            }
            else
            {
                
                for (var c:Number = 0; c < 15; c ++)
                {
                    var dot3D:DisplayObject3D = char3D.getChildByName("dot"+c);
                    Tweener.addTween(dot3D,{scale:chars[char][c],y:rand,time:1,transition:"easeOutElastic"});
                }
            }
        }        
        
        
        public function updateClock(e:Event):void
        {
            var actual_time:Date = new Date();
            
            var fulltime:String = doubleDigitFormat(actual_time.getHours())+":"+
                                  doubleDigitFormat(actual_time.getMinutes())+":"+
                                  doubleDigitFormat(actual_time.getSeconds());
                                  
            for (var i:Number = 0; i < 8; i++)
            {
                var char:String = fulltime.substr(i,1);
                if (char == ":") char = "10";
                updateChar3D(i,char);
            }
        }
        
        
        // .. LOOP ...........................................................................................................
        
        
        private function loop(e:Event):void
        {
            camera.x += ( ( ((stage.stageWidth * .5) - mouseX) * .5 ) - camera.x ) * .05;
            camera.y += ( ( (stage.stageHeight - mouseY) * 4 ) - camera.y ) * .05;
            camera.z += ( ( (-mouseY) * 2 ) - camera.z ) * .05;
            
            // Lets swicth the materials for creating the shadow texture

            //floor.material = white;
            
            //renderer.renderScene(scene,camera_shadow,viewport_shadow);
            
            //floor.material = shadowMat;
            
            //floor.material.bitmap.colorTransform(floor.material.bitmap.rect,new ColorTransform(1,1,1,1,100,100,100,0));
            //floor.material.bitmap.applyFilter(floor.material.bitmap,floor.material.bitmap.rect,new Point(0,0),new BlurFilter(20,20,2));
            
            //renderer.renderScene(scene,camera,viewport);
            singleRender();
        }
        
        private function tick(e:Event):void
        {
            camera.x += ( ( ((stage.stageWidth * .05) - mouseX) * .5 ) - camera.x ) * .05;
            camera.y += ( ( (stage.stageHeight - mouseY) * 4 ) - camera.y ) * .05;
            camera.z += ( ( (-mouseY) * 2 ) - camera.z ) * .05;
        }

        
    }
}