/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zZYJ
 */

//
//	マウスに追尾してくる点達の沿ってラインを描くことが出来ます。
//	http://wonderfl.net/code/74d3bab0ab20e07718ef059909bacff6932239ce の改良版です。Forkはしませんでした。
//  http://www.escapemotions.com/experiments/flame/#top これを意識して作ってます
//	Created by おこい
//
package 
{
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.Graphics;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;

	[SWF(backgroundColor = "0x000000", frameRate = "40")]

	
	/**
	 * 
	 * @author okoi
	 */
	public class Main extends Sprite 
	{
		private var pathMC:MovieClip = new MovieClip();
		private var pathList:Array = new Array(); 
		
		private var drawBMPData:BitmapData;
		private var drawBMP:Bitmap;
		private var drawMC:MovieClip = new MovieClip();

		private var drawFlag:int = 0;
				
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			addChild(pathMC);
			drawBMPData = new BitmapData( stage.stageWidth,  stage.stageHeight, true, 0x00000000 );
			drawBMP = new Bitmap(drawBMPData);
			addChild(drawBMP);

			
			for ( var i:int = 0; i < 100; i++ )
			{
				var a:Number = ((i - 100 / 2) * (i - 100 / 2)) / (50 * 50);
				pathList.push( new Path( 0.1 + i/100 * 0.4, 0.9, a / 3) );
			}
			
			addEventListener(Event.ENTER_FRAME, EnterFrame);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, ChangeDrawFlag );
			//stage.addEventListener(MouseEvent.MOUSE_OUT, ChangeDrawFlag );
			stage.addEventListener(MouseEvent.MOUSE_UP, ChangeDrawFlag );
		}
		
		public	function EnterFrame(event:Event):void 
		{
			var p:Path;
			
			var g:Graphics = pathMC.graphics;
			g.clear();
			g.beginFill( 0xFFFFFF, 1 );
			for each ( p in pathList )
			{
				p.Run( stage.mouseX, stage.mouseY );
				if( !drawFlag )	g.drawCircle( p.x, p.y, 1 );
			}
			
			//	描画部分
			if ( drawFlag )
			{
				g = drawMC.graphics;
				g.clear();
				for each ( p in pathList )
				{
					g.lineStyle (1, p._color, p._alpha);	// 線のスタイル
					g.moveTo( p._prevX, p._prevY );
					g.lineTo( p.x, p.y );
				}
				//	書いたデータをビットマップに追加
				drawBMPData.draw( drawMC, null, null, BlendMode.ADD ); 
			}
		}
		public	function ChangeDrawFlag(event:MouseEvent):void 
		{
			if ( event.type == MouseEvent.MOUSE_OUT && drawFlag == 0 ) return;
			
			drawFlag ^= 1;
			
			var colorMax:uint = 0xFFFF;
			var colorMin:uint = 0xFF00;
			
			for ( var i:int = 0; i < pathList.length - 1; i++ )
			{
				pathList[i].SetColor( 0xFF0000 + 0xFF00 * (i/(pathList.length-1)) );
			}
			
		}	
	}
	
}
import flash.display.MovieClip;
import flash.display.Sprite;
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
//
//	マウス追従パスクラス
//
class Path extends Sprite {
	
	public var _prevX:Number;
	public var _prevY:Number;
	
	private var _targetX:Number;
	private var _targetY:Number;
	
	private var _moveX:Number;
	private var _moveY:Number;
	
	private var _power1:Number;
	private var _power2:Number;
	
	public var _alpha:Number;
	public var _color:uint;
	
	public function Path(p1:Number = 0.1, p2:Number = 0.9, alpha:Number = 1.0) {
		super();
		this.x = 0;
		this.y = 0;
		_prevX = 0;
		_prevY = 0;
		_moveX = 0;
		_moveY = 0;
		_power1 = p1;
		_power2 = p2;
		_alpha  = alpha;
		_color = 0xFF0000;
		
	}
	
	public function SetColor(c:uint) : void {
		_color = c;
	}
	
	public function Run(_tX:Number, _tY:Number):void {
		
		_prevX = this.x;
		_prevY = this.y;
		
		if ( Math.abs( _tX - this.x ) < 1 && Math.abs( _tY - this.y ) < 1 ) return;
		
		_targetX = _tX;
		_targetY = _tY;
		
		_moveX += (_targetX - this.x) * _power1;
		_moveX *= _power2;
			
		_moveY += (_targetY - this.y) * _power1;
		_moveY *= _power2;
		
		this.x += _moveX;
		this.y += _moveY;	
		
	}
	
	
}