/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zZV0
 */

/*
    マイクから音を取ってきて無限ループ再生
*/
package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.ActivityEvent;
    import flash.events.Event;
    import flash.events.SampleDataEvent;
    import flash.media.Microphone;
    import flash.media.Sound;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.utils.ByteArray;
    
    public class Microphone_test01 extends Sprite
    {
        // 録音時間
        private static const record:int = 10;
        
        private var mic:Microphone;
        private var bytes:ByteArray;
        private var startTIme:Number;
        private var tf:TextField;
        private var sound:Sound;
        
        public function Microphone_test01():void
        {
            // ステージの設定
            stage.align=StageAlign.TOP_LEFT;
            stage.scaleMode=StageScaleMode.NO_SCALE;
            
            // データを保存するByteArray
            bytes=new ByteArray;
            
            // マイクの設定
            mic=Microphone.getMicrophone();
            mic.rate=44;
            mic.gain = 100;
            mic.setSilenceLevel(0, 0);
            mic.setUseEchoSuppression(true);
            mic.setLoopBack(true);
            mic.addEventListener(SampleDataEvent.SAMPLE_DATA, micSampleData);
            mic.addEventListener(ActivityEvent.ACTIVITY, onStart);
        }
        
        // マイクがアクティブになったら、タイマーを作成して録音開始
        private function onStart(e:ActivityEvent):void
        {
            // 時間を測る
            tf=addChild(new TextField)as TextField;
            tf.autoSize=TextFieldAutoSize.LEFT;
            tf.scaleX=tf.scaleY=2;
            tf.x=tf.y=10;
            startTIme=(new Date).getTime();
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        // 音をByteArrayに書き込む
        private function micSampleData(e:SampleDataEvent):void
        {
            bytes.writeBytes(e.data);
        }
        
        // 20秒たったら録音をやめて再生する
        private function onFrame(e:Event):void
        {
            var now:Number=(new Date).getTime();
            var diff:int=(now - startTIme) * 0.001;
            tf.text=record.toString()+"秒、録音を行います。\n" + createTimeText(diff);
            
            if (diff >= record)
            {
                removeEventListener(Event.ENTER_FRAME, onFrame);
                mic.removeEventListener(SampleDataEvent.SAMPLE_DATA, micSampleData);
                mic.setLoopBack(false);
                
                tf.text = "録音した音声を再生します(無限ループ)。";
                
                bytes.position=0;
                sound=new Sound;
                sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onPlay);
                sound.play();
            }
        }
        
        // 秒数を時間表示用 mm:ss に整形する関数
        private function createTimeText(time:int):String
        {
            var m:int=(time / 60) >> 0;
            var s:int=(time % 60) >> 0;
            var str:String=((m < 10) ? ("0" + m.toString()) : (m.toString()));
            str+=":" + ((s < 10) ? ("0" + s.toString()) : (s.toString()));
            
            return str;
        }
        
        // 再生 (無限ループ)
        private function onPlay(e:SampleDataEvent):void
        {
            for(var i:int=0; i < 2048; i++)
            {
                var wav:Number=bytes.readFloat();
                e.data.writeFloat(wav);
                e.data.writeFloat(wav);
            }
            
            if (bytes.bytesAvailable <= 0) bytes.position=0;
        }
    }
}

