/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zYzo
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    [SWF(width="465",height="465",frameRate="60",backgroundColor="#000000")]
    public class FlashTest extends Sprite {
        private var bmd_:BitmapData;
        private var bufferBmd_:BitmapData;
        
        private var rect_:Rectangle;
        private const ZERO_POINT:Point = new Point();
        private const BLUR:BlurFilter = new BlurFilter(4, 4, BitmapFilterQuality.HIGH);
        private var matrix_:Matrix = new Matrix();
        private var cnt_:int = 3600;
        
        private var rl_:Number;
        private var im_:Number;
        
        private var color_:uint;
        private var angle_:Number = 0.0;
        private const STEP:Number = 180 / cnt_;
        
        private var textField_:TextField;
        
        private var w:int = stage.stageWidth;
        private var h:int = stage.stageHeight;
        
        public function FlashTest() {
            bufferBmd_ = new BitmapData(w, h, true, 0x00000000);
            rect_ = bufferBmd_.rect;
            bmd_ = new BitmapData(w, h, true, 0xff000000);
            addChild(new Bitmap(bmd_));
            matrix_.rotation(Math.PI / 2);
            matrix_.translate(w, 0);
            Buddhabrot.setup(w, h);
            Buddhabrot.scale = 1.5;
            
            textField_ = new TextField();
            textField_.autoSize = TextFieldAutoSize.LEFT;
            textField_.defaultTextFormat = new TextFormat("_typewriter", 12, 0xffffff);
            addChild(textField_);
            angle_ = Math.random() * 360 >> 0;
            addEventListener(Event.ENTER_FRAME, update);            
        }
        private function update(e:Event):void
        {
            color_ = CycleRGB.getColor(angle_);
            color_ = 0x66 << 24 | color_;
            angle_ += STEP;
            
            rl_ = Math.random()*2-1.5;
            im_ = Math.random()*2-1;
            draw(rl_, im_, color_);
            rl_ = Math.random()*2-1.5;
            im_ = Math.random()*2-1;
            draw(rl_, im_, color_);
            
            textField_.text = String(cnt_);
            
            if(cnt_-- <= 0) {
                textField_.text = "Complete!";
                removeEventListener(Event.ENTER_FRAME, arguments.callee);
            }    
        }
        
        private function draw(val1:Number, val2:Number, color:uint):void {
            Buddhabrot.rl = val1;
            Buddhabrot.im = val2;
            var data:Vector.<int> = Buddhabrot.update();
            if(!data) return;
            
            var len:uint = date.length / 2;
            bufferBmd_.lock();
            bufferBmd_.fillRect(rect_, 0x00000000);
            for(var i:int=0; i<len; i++) {
                var idx1:uint = i * 2;
                var idx2:uint = idx1 + 1;
                var x:int = data[idx1];
                var y1:int = data[idx2];
                var y2:int = h - data[idx2];
                bufferBmd_.setPixel32(x, y1, color);
                bufferBmd_.setPixel32(x, y2, color);
            }
            bufferBmd_.applyFilter(bufferBmd_,rect_,ZERO_POINT, BLUR);
            bufferBmd_.unlock();
            bmd_.draw(bufferBmd_, matrix_, null, BlendMode.ADD);
            bmd_.unlock();
        }
    }
}

class Buddhabrot {
    static public function set rl(value:Number):void {_rl=value;}
    static private var _rl:Number = 0.0;
    static public function set im(value:Number):void {_im=value;}
    static private var _im:Number = 0.0;
    
    static public function set degree(value:int):void {
        _degree = value;
    }
    static private var _degree:int = 1000;
    
    static public function set scale(value:Number):void {
        _scale = value;
        calcInterval();
    }
    static private var _scale:Number = 1.0;
    static private var width_:int;
    static private var height_:int;
    static private var halfWidth_:Number;
    static private var halfHeight_:Number;
    static private var interval_:Number;
    
    static public function setup(width:int, height:int):void {
        width_ = width;
        height_ = height;
        halfWidth_ = width_/2;
        halfHeight_ = height_/2
        
        calcInterval();
    }
    
    static private function calcInterval():void {
        var shorter:int = (width_ < height_) ? width_:height_;
        interval_ = (_scale * shorter) / 4;        
    }
    
    static public function update():Vector.<int> {
        var data:Vector.<int> = new Vector.<int>(_degree * 2, true);
        
        var zRl:Number = _rl;
        var zIm:Number = _im;
        var zRlSqr:Number;
        var zImSqr:Number;
        var zRlNxt:Number;
        var zImNxt:Number;
        
        for(var i:int=0; i<_dgree; i++) {
            
        }

    }

}
