/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zYNn
 */

package 
{
    import flash.display.Shape;
    import flash.display.Sprite;
    
    /**
     * ...
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class Test243 extends Sprite 
    {
        private var boxList: Array = [];
        
        public function Test243() 
        {
            var oneSideLength: int = 17;
            var i: int, n: int = 270;
            for (i = 0; i < n; i++) 
            {
                boxList[i] = createBox((0xFF * (n - i) / n) << 0x08 | (0xFF * i / n), stage.stageWidth / oneSideLength, stage.stageHeight / oneSideLength);
            }
            layout(oneSideLength);
        }
        
        private function layout(oneSideLength: int): void 
        {
            var i: int, j: int, n: int = boxList.length;
            var ix: int, iy: int;
            for (i = 0; i < n; i++) 
            {
                var box: Shape = boxList[i];
                var frameLength: int = oneSideLength - 1;
                if (frameLength < 0)
                {
                    return;
                }
                addChild(box);
                box.x = ix * box.width, box.y = iy * box.height;
                if (j == frameLength * 4 - 1)
                {
                    ix ++, oneSideLength -= 2, j = 0;
                }
                else 
                {
                    switch (int(j / frameLength))
                    {
                        case 0: ix++; break;
                        case 1: iy++; break;
                        case 2: ix--; break;
                        case 3: iy--; break;
                    }
                    j++;
                }
            }
        }
        
        private function createBox(color: uint, w: int, h: int): Shape
        {
            var box: Shape = new Shape();
            box.graphics.beginFill(color);
            box.graphics.lineStyle(0, 0xFFFFFF);
            box.graphics.drawRect(0, 0, w, h);
            return box;
        }
    }
}