/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zXbA
 */

package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	public class Main extends Sprite
	{
		private var balls:Vector.<Ball> = new Vector.<Ball>();
		private var canvas:BitmapData;
		private var circle:BitmapData;
		private var text:BitmapData;
		
		public function Main()
		{
			var tf:TextField = new TextField();
			tf.defaultTextFormat = new TextFormat("_typeWriter", 100, 0x0, true);
			tf.autoSize = "left";
			tf.text = "Effect";

			text = new BitmapData(stage.stageWidth, stage.stageHeight, false);
			text.draw(tf);
			
			var c:Sprite = new Sprite();
			c.graphics.beginFill(0x009AD6);
			c.graphics.drawCircle(5, 5, 1);
			c.graphics.endFill();
			
			circle = new BitmapData(10, 10, true, 0x0);
			circle.draw(c);
			circle.applyFilter(circle, circle.rect, new Point(), new GlowFilter(0xFFFFFF));
			
			addChild(new Bitmap(canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0)));
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(event:Event):void 
		{
			for (var i:int = 0; i < 3; i++)
			{
				var ball:Ball = new Ball();
				ball.x = Math.random() * stage.stageWidth;
				ball.y = 0;
				ball.vy = Math.random() * 3 + 3;
				balls.push(ball);
			}
						
			canvas.fillRect(canvas.rect, 0x0);
			
			for (i = 0; i < balls.length; i++)
			{
				ball = balls[i];
				if (text.getPixel(ball.x, ball.y) == 0xFFFFFF) ball.y += ball.vy;
				else ball.y += ball.vy / 50;
				canvas.copyPixels(circle, circle.rect, new Point(ball.x, ball.y), null, null, true);
				
				if (ball.y >= stage.stageHeight + 10)
				{
					balls.splice(i--, 1);
				}
			}
		}
	}
}

class Ball
{
	public var x:Number;
	public var y:Number;
	
	public var vx:Number;
	public var vy:Number;
}