/**
 * Copyright ll_koba_ll ( http://wonderfl.net/user/ll_koba_ll )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zXKp
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.net.*;
    import flash.system.*;
    import jp.progression.commands.*;
    import jp.progression.commands.lists.*;
    import jp.progression.commands.display.*;
    import jp.progression.commands.net.*;
    import jp.progression.commands.tweens.*;
    import jp.progression.events.*;

    import caurina.transitions.*;
    [SWF(frameRate=30, width=500, height=500, backgroundColor="#FFFFFF")]
        public class Wanco01 extends Sprite {
            public static var GRAPHICS_URL:String = "http://swf.wonderfl.net/static/assets/checkmate05/wancoAmateur.swf";
            private var _motionList:Array = [
                "StayMotion",
                //"JumpMotion",
                //"HighJumpMotion",
                "WalkMotion",
                "RunMotion",
                "SquatMotion",
                "QuestionMotion",
                "ExclamationMotion",
                "HeartMotion",
                "PoutMotion",
                "StarMotion",
                "SingMotion",
                "SleepMotion",
                "WakeMotion"
                    ];

            public function Wanco01(){
                super();
                Wonderfl.capture_delay( 30 );
                stage.scaleMode = StageScaleMode.NO_SCALE;
                stage.align = StageAlign.TOP_LEFT;

                var target:Sprite = this;

                var com:SerialList = new SerialList();
                com.addCommand(
                        new LoadSWF( new URLRequest( GRAPHICS_URL ) ),
                        function():void {
                        var loader:Loader = Loader( this.latestData );
                        var domain:ApplicationDomain = loader.contentLoaderInfo.applicationDomain;
                        target.addChild(new World(_motionList, domain));
                        }
                        );
                com.execute();
            }
        }
}

import flash.display.*;
import flash.events.*;
import flash.net.*;
import flash.system.*;
import flash.utils.*;

import Box2D.Dynamics.*;
import Box2D.Collision.*;
import Box2D.Collision.Shapes.*;
import Box2D.Dynamics.Joints.*;
import Box2D.Dynamics.Contacts.*;
import Box2D.Common.*;
import Box2D.Common.Math.*;

import net.hires.debug.Stats;

class World extends Sprite 
{
    private var _world:b2World;
    private const DRAW_SCALE:Number = 100;
    private var _iterations:int = 10;
    private var _timeStep:Number = 1.0/30.0;
    private var _debug:Boolean = false
    private var _gravity:b2Vec2;
    private var _doSleep:Boolean = false
    private var _motionList:Array;
    private var _domain:ApplicationDomain;
    private var _wancoTimer:Timer

    public function World(list:Array, domain:ApplicationDomain ) 
    {
        trace(list);
        addEventListener(Event.ADDED_TO_STAGE, init);
        _motionList = list;
        _domain = domain;
        //addChild(new Stats());
     }

    private function init(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);

        var worldAABB:b2AABB = new b2AABB();
        worldAABB.lowerBound.Set(-100, -100);
        worldAABB.upperBound.Set(100, 100);

        _gravity = new b2Vec2(0, 10);
        _world = new b2World(worldAABB, _gravity, _doSleep);

        // デバッグ表示
        if (_debug) 
        {
            var dbgDraw:b2DebugDraw = new b2DebugDraw();
            var dbgSprite:Sprite = new Sprite();
            addChild(dbgSprite);
            dbgDraw.m_sprite = dbgSprite;
            dbgDraw.m_drawScale = DRAW_SCALE;
            dbgDraw.m_fillAlpha = 0.0;
            dbgDraw.m_alpha = 1.0;
            dbgDraw.m_lineThickness = 1.0;
            dbgDraw.m_drawFlags = 0xFFFFFFFF;
            _world.SetDebugDraw(dbgDraw);
        }

        var stw:Number = stage.stageWidth;
        var sth:Number = stage.stageHeight;
        createBox("floor", stw/2, sth, stw, 10);
        addEventListener(Event.ENTER_FRAME, update);
        _wancoTimer = new Timer(1000);
        _wancoTimer.addEventListener(TimerEvent.TIMER, timerHandler); 
        _wancoTimer.start();
    }

    private function timerHandler(e:TimerEvent):void
    {
        createWanco("wanco", Math.random()*stage.stageWidth, -50);
    }

    private function createBox(id:String, x:Number, y:Number, w:Number, h:Number):void 
    {
        var bodyDef:b2BodyDef = new b2BodyDef();
        bodyDef.position.x = x/DRAW_SCALE;
        bodyDef.position.y = y/DRAW_SCALE;
        bodyDef.userData = {};
        bodyDef.userData.id = id;

        var display:Sprite = new Sprite();
        var g:Graphics = display.graphics;
        g.lineStyle(1, 0xFFFFFF);
        g.drawRect(-w/2,-h/2,w,h);
        addChild(display);
        bodyDef.userData.displayObject = display;

        var boxDef:b2PolygonDef = new b2PolygonDef();
        boxDef.SetAsBox(w/2/DRAW_SCALE, h/2/DRAW_SCALE);
        boxDef.density = 0; // 固定されたオブジェクトに

        var body:b2Body = _world.CreateBody(bodyDef);
        body.CreateShape(boxDef);
    }

    private function createWanco(id:String, x:Number, y:Number):void 
    {
        var wan:MovieClip = new ( _domain.getDefinition( _motionList[Math.floor(Math.random()*_motionList.length)]) as Class );
        wan.stop();

        var s:Sprite = new Sprite();
        s.addChild(wan);
        addChild(s);
        s.x = -100;
        s.y = -100;

        var bodyDef:b2BodyDef = new b2BodyDef();
        bodyDef.position.x = x/DRAW_SCALE;
        bodyDef.position.y = y/DRAW_SCALE;
        bodyDef.userData = {};
        bodyDef.userData.id = id;
        bodyDef.userData.displayObject = s;

        var boxDef:b2PolygonDef = new b2PolygonDef();
        var scale:Number = scale = 1 + Math.random();
        wan.scaleX = wan.scaleY = scale;
        wan.y = 55*scale;

        boxDef.vertexCount = 6;
        boxDef.vertices[0].Set(5*scale/DRAW_SCALE, 0*scale/DRAW_SCALE);
        boxDef.vertices[1].Set(30*scale/DRAW_SCALE, 40*scale/DRAW_SCALE);
        boxDef.vertices[2].Set(20*scale/DRAW_SCALE, 55*scale/DRAW_SCALE);
        boxDef.vertices[3].Set(-20*scale/DRAW_SCALE, 55*scale/DRAW_SCALE);
        boxDef.vertices[4].Set(-30*scale/DRAW_SCALE, 40*scale/DRAW_SCALE);
        boxDef.vertices[5].Set(-5*scale/DRAW_SCALE, 0*scale/DRAW_SCALE);

        boxDef.density = 0.5;
        boxDef.friction = 0.7;
        boxDef.restitution = 0.4;

        var body:b2Body = _world.CreateBody(bodyDef);
        body.CreateShape(boxDef);
        body.SetMassFromShapes();
        
    }

    private function update(event:Event):void 
    {
        if (_world == null) return;

        _world.Step(_timeStep, 5);      

        for (var bb:b2Body = _world.m_bodyList; bb; bb = bb.m_next) {
            if (bb.m_userData) {
                if (bb.m_userData.displayObject is Sprite) {
                    var p:Object = bb.GetPosition();
                    var d:DisplayObject = bb.m_userData.displayObject;
                    d.x = p.x * DRAW_SCALE;
                    d.y = p.y * DRAW_SCALE;
                    d.rotation = bb.GetAngle() * (180/Math.PI);
                    if(d.y > stage.stageHeight ) {
                        removeChild(d);
                        _world.DestroyBody(bb);
                    }
                } 
            }
        }            
    } 
}


