/**
 * Copyright 178ep3 ( http://wonderfl.net/user/178ep3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zXGj
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/

//  ドット絵と聞くと
//　やっぱコレ。
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
   [SWF(width=465, height=465, frameRate=9, backgroundColor=0x000000)]     
    public class Professional extends Sprite {
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var list:Array = [Mario1(),Mario2(),Mario3()];
            var pattern:BitmapData = Mario2();
            
            var g:Graphics = graphics;
            g.beginBitmapFill(pattern);
            g.drawRect(0,0,480,480);
            g.endFill();
            
            addEventListener(Event.ENTER_FRAME,loop);
            
            var f:uint=0;
            function loop(e:Event):void
            {
            	pattern = list[f];
            	f++;
            	if(f==3)f=0;
            	
            	g.clear();
            	g.beginBitmapFill(pattern);
          		g.drawRect(0,0,480,480);
          		g.endFill();
            }
        }
        
        public function Mario1():BitmapData{ 
             return BitmapPatternBuilder.build( 
                [[0 , 0 , 0 , 0 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 0 , 0], 
                                [0 , 0 , 0 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 2 , 2 , 2 , 3 , 3 , 2 , 3 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 2 , 3 , 2 , 3 , 3 , 3 , 2 , 3 , 3 , 3 , 0 , 0 , 0 , 0], 
                [0 , 0 , 2 , 3 , 2 , 2 , 3 , 3 , 3 , 2 , 3 , 3 , 3 , 0 , 0 , 0], 
                [0 , 0 , 2 , 2 , 3 , 3 , 3 , 3 , 2 , 2 , 2 , 2 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 0 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 0 , 0 , 0 , 0 , 0], 
                [0 , 2 , 2 , 2 , 2 , 1 , 1 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 0 , 0], 
                [3 , 2 , 2 , 2 , 2 , 1 , 1 , 1 , 2 , 2 , 2 , 3 , 3 , 3 , 0 , 0], 
                [3 , 3 , 0 , 2 , 2 , 1 , 3 , 1 , 1 , 1 , 2 , 2 , 3 , 3 , 0 , 0], 
                [3 , 0 , 0 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 2 , 0 , 0 , 0], 
                [0 , 0 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 2 , 2 , 0 , 0 , 0], 
                [0 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 2 , 2 , 0 , 0 , 0], 
                [2 , 2 , 1 , 1 , 1 , 0 , 0 , 0 , 1 , 1 , 1 , 2 , 2 , 0 , 0 , 0], 
                [2 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 2 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0],], 
                [0xff000000,0xffff0000, 0xff9e7825,0xfffca728,0xffd550] 
                ); 
        } 
         
        public function Mario2():BitmapData{ 
             return BitmapPatternBuilder.build( 
                [[0 , 0 , 0 , 0 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 0 , 0], 
                                [0 , 0 , 0 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 2 , 2 , 2 , 3 , 3 , 2 , 3 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 2 , 3 , 2 , 3 , 3 , 3 , 2 , 3 , 3 , 3 , 0 , 0 , 0 , 0], 
                [0 , 0 , 2 , 3 , 2 , 2 , 3 , 3 , 3 , 2 , 3 , 3 , 3 , 0 , 0 , 0], 
                [0 , 0 , 2 , 2 , 3 , 3 , 3 , 3 , 2 , 2 , 2 , 2 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 0 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 2 , 2 , 1 , 2 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 2 , 2 , 2 , 2 , 1 , 1 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 2 , 2 , 2 , 1 , 1 , 3 , 1 , 1 , 3 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 2 , 2 , 2 , 2 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 1 , 2 , 2 , 3 , 3 , 3 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 1 , 2 , 3 , 3 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 0 , 1 , 1 , 1 , 2 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 0 , 2 , 2 , 2 , 2 , 2 , 2 , 2 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 0 , 2 , 2 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0]], 
                [0xff000000,0xffff0000, 0xff9e7825,0xfffca728,0xffd550] 
                ); 
        } 
         
        public function Mario3():BitmapData{ 
             return BitmapPatternBuilder.build( 
                [[0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0], 
                                [0 , 0 , 0 , 0 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 2 , 2 , 2 , 3 , 3 , 2 , 3 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 2 , 3 , 2 , 3 , 3 , 3 , 2 , 3 , 3 , 3 , 0 , 0 , 0 , 0], 
                [0 , 0 , 2 , 3 , 2 , 2 , 3 , 3 , 3 , 2 , 3 , 3 , 3 , 0 , 0 , 0], 
                [0 , 0 , 2 , 2 , 3 , 3 , 3 , 3 , 2 , 2 , 2 , 2 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 0 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 2 , 2 , 2 , 2 , 1 , 2 , 0 , 3 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 3 , 2 , 2 , 2 , 2 , 2 , 2 , 3 , 3 , 3 , 0 , 0 , 0 , 0], 
                [0 , 3 , 3 , 1 , 2 , 2 , 2 , 2 , 2 , 3 , 3 , 0 , 0 , 0 , 0 , 0], 
                [0 , 2 , 2 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 2 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 0], 
                [2 , 2 , 1 , 1 , 1 , 0 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 0 , 0], 
                [2 , 0 , 0 , 0 , 0 , 2 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0], 
                [0 , 0 , 0 , 0 , 0 , 2 , 2 , 2 , 2 , 0 , 0 , 0 , 0 , 0 , 0 , 0]], 
                [0xff000000,0xffff0000, 0xff9e7825,0xfffca728,0xffd550] 
                );
        }
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}