/**
 * Copyright breathxue ( http://wonderfl.net/user/breathxue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zXDx
 */

// forked from paq's [Stardust] StarDust
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
    
    /*
     * 題名的にやるしかない！と思ったのでfork
     */
    [SWF(backgroundColor="0x000000", width=465, height=465, frameRate=60)]
    public class StarDust extends Sprite
    {
        //色を変化させるためのもの
        private var colorTrans:ColorTransform;

        //大量のボールを描画するSprite
        private var canvas:Sprite;
        //表示用Bitmap
        private var bmp:Bitmap;
        //canvasの内容を記録するためのBitmapData
        private var bmpData:BitmapData;
        
        // エミッター
        private var emitter:StarDustEmitter;

        public function StarDust()
        {
            colorTrans=new ColorTransform(0.8, 0.95, 0.99, 0.9);

            canvas = new Sprite();
            bmpData=new BitmapData(512, 512, true, 0xFF00000);
            bmp=new Bitmap(bmpData);
            addChild(bmp);
            
            // エミッターとレンダラーを作成
            emitter = new StarDustEmitter(new SteadyClock(1), new GlowFilter(0, 1, 16, 16, 2));
            var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(canvas);
            renderer.addEmitter(emitter);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onEnterFrame(event:Event):void
        {
            // エミッターを更新
            emitter.point.x = mouseX;
            emitter.point.y = mouseY;
            emitter.step();
            
            //canvas上に描かれている内容をbmpDataに格納
            bmpData.draw(canvas);
            //色変化エフェクトを適用
            bmpData.colorTransform(bmpData.rect, colorTrans);
        }
    }
}

import flash.display.Sprite;
import flash.filters.GlowFilter;
import idv.cjcat.stardust.common.actions.Action;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.emitters.Emitter;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.common.particles.Particle;
import idv.cjcat.stardust.twoD.actions.Action2D;
import idv.cjcat.stardust.twoD.actions.DeathZone;
import idv.cjcat.stardust.twoD.actions.Gravity;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.Spin;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Omega;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.particles.Particle2D;
import idv.cjcat.stardust.twoD.zones.CircleZone;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.RectZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;

class StarDustEmitter extends Emitter2D 
{
    public var point:SinglePoint;
    
    public function StarDustEmitter(clock:Clock, grow:GlowFilter)
    {
        super(clock);
        
        // イニシャライザーを登録
        point = new SinglePoint();
        var position:Position = new Position(point);
        addInitializer(position);
        addInitializer(new DisplayObjectClass(Star, [grow]));
        addInitializer(new Velocity(new CircleZone(0, 0, 5)));
        addInitializer(new Omega(new UniformRandom(5, 5)));
        
        // アクションを登録
        var gravity:Gravity = new Gravity();
        gravity.addField(new UniformField(0.15, 0.2));
        addAction(gravity);
        addAction(new Move());
        addAction(new DeathZone(new RectZone(0, 0, 465, 465), true));
        addAction(new Spin());
        addAction(new StarAction());
    }
}

class StarAction extends Action
{
    public function StarAction(){}
    override public function update(emitter:Emitter, particle:Particle, time:Number):void
    {
        particle.target.z += particle.target.vz;
    }
}

class Star extends Sprite
{
    public var vz:Number;

    public function Star(glow:GlowFilter)
    {
        vz = -Math.random() * 10;
        
        //Glowの色の設定
        glow.color = Math.random() * 0xffffff;
        //フィルターの適用
        filters = [glow];
        
        var r:Number = Math.random() * 8 + 5;
        var p:int = 5;
        
        var r2:Number=r / 2;
        var angle:Number=-90;
        var addtion:Number=360 / (p * 2);
        graphics.beginFill(0xffffff);
        graphics.moveTo(0, -r);
        for (var i:int=0; i < p * 2; i++)
        {
            angle+=addtion;
            var to_x:Number;
            var to_y:Number;
            var radian:Number=angle * Math.PI / 180;
            if (i % 2)
            {
                to_x=r * Math.cos(radian);
                to_y=r * Math.sin(radian);
            }
            else
            {
                to_x=r2 * Math.cos(radian);
                to_y=r2 * Math.sin(radian);
            }
            graphics.lineTo(to_x, to_y);
        }
        graphics.endFill();
    }
}
