/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zVVR
 */

// forked from tkinjo's カラーグリッド（ drawRect を setPixel へ変更 ）
// forked from tkinjo's forked from: カラーグリッド
// forked from tkinjo's カラーグリッド
// forked from tkinjo's ストライプ
// forked from tkinjo's minimalcomps を使ってコンポーネントを作ってみた
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * カラーグリッド（ setPixel を setPixels へ変更 ）
     * 
     * 画像の情報を一度 ByteArray へ格納後、 
     * setPixels で BitmapData に情報をセット
     * 
     * 余計なことをせずに setPixel を使ったほうが動作が軽いです…。
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private var stageWidth:Number = stage.stageWidth;
        private var stageHeight:Number = stage.stageHeight;
        
        private var configPanel:SlidePanel;
        
        private var gridNumInputTextAndHSlider:InputTextAndHSlider;
        
        private var viewBitmapData:BitmapData;
        private var viewBitmap:Bitmap;
        
        public function Main() 
        {
            viewBitmapData = new BitmapData( stageWidth, stageHeight, false );
            viewBitmap = new Bitmap( viewBitmapData );
            addChild( viewBitmap );
            
            setComponent();
            
            draw();
        }
        
        private function setComponent():void {
            
            configPanel = new SlidePanel( 0, 0, stageWidth, 36 );
            addChild( configPanel );
            
            
            // gridNum
            gridNumInputTextAndHSlider = new InputTextAndHSlider( configPanel, 10, 10 );
            gridNumInputTextAndHSlider.inputText.width = 30;
            gridNumInputTextAndHSlider.round = 0;
            gridNumInputTextAndHSlider.value = 64;
            gridNumInputTextAndHSlider.hSlider.maximum = stageWidth;
            gridNumInputTextAndHSlider.hSlider.width = 380;
            gridNumInputTextAndHSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                    
                    draw();
                } );
            
            
            //addChild(new Stats);
        }
        
        private function draw():void {
            
            graphics.clear();
            
            var gridNum     :uint = gridNumInputTextAndHSlider.value;
            var gridNumPower:Number = Math.pow( gridNum, 2 );
            var gridWidth   :Number = stageWidth  / gridNum;
            var gridHeight  :Number = stageHeight / gridNum;
            var gridWidthUINT :uint = uint( stageWidth );
            var gridHeightUINT:uint = uint( stageHeight );
            
            var rect:Rectangle = new Rectangle( 0, 0, gridWidth, gridHeight );
            var canvasByteArray:ByteArray = new ByteArray();
            canvasByteArray.length = 465 * 465 * 4;
            var position:int;
            
            for ( var i:uint = 0; i < gridNum; i++ ) {
                
                for ( var j:uint = 0; j < gridNum; j++ ) {
                    
                    var color:uint = 0xffffff / ( gridNumPower - 1 ) * ( i + ( j * gridNum ) );
                    var red  :uint = color >> 16 & 0xff;
                    var green:uint = color >> 8  & 0xff;
                    var blue :uint = color       & 0xff;
                    
                    for ( var k:uint = 0; k < gridWidth; k++ ) {
                        
                        position = ( uint( i * gridWidth ) + uint( k + ( j * gridHeight ) ) * stageHeight ) * 4;
                        
                        for ( var l:uint = 0; l < gridHeight; l++ ) {
                            
                            canvasByteArray[ position + 1 ] = red;   // red
                            canvasByteArray[ position + 2 ] = green; // green
                            canvasByteArray[ position + 3 ] = blue;  // blue
                            position += 4;
                        }
                    }
                }
            }
            viewBitmapData.setPixels( viewBitmapData.rect, canvasByteArray );
        }
    }
}



import com.bit101.components.*;
import flash.display.*;
import flash.events.*;
import flash.geom.*;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Cubic;


/* -----
 * component
 */

class InputTextEx extends InputText {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    public function InputTextEx(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, text:String = "", defaultHandler:Function = null)
    {
        super( parent, xpos, ypos, text, defaultHandler );
    }
    
    protected override function onChange(event:Event):void
    {
        super.onChange( event );
        dispatchEvent( event );
    }
}

class HSliderEx extends HSlider {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    /**
     * ...
     * @eventType com.bit101.components.Component.DRAW
     */
    [Event(name = "draw", type = "com.bit101.components.Component")] 
    
    public function HSliderEx(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0, defaultHandler:Function = null):void
    {
        super(parent, xpos, ypos, defaultHandler);
    }
}

class InputTextAndHSlider extends Sprite {
    
    /**
     * Dispatched after a control value is modified, unlike the textInput event, which is dispatched before the value is modified.
     * @eventType flash.events.Event.CHANGE
     */
    [Event(name = "change", type = "flash.events.Event")] 
    
    
    
    /**
     * inputText
     */
    public function get inputText():InputTextEx {
        
        return _inputText;
    }
    private var _inputText:InputTextEx;
    
    
    
    /**
     * hSlider
     */
    public function get hSlider():HSliderEx {
        
        return _hSlider;
    }
    private var _hSlider:HSliderEx;
    
    
    
    /**
     * round
     */
    public var round:int = 2;
    
    
    
    /**
     * value
     */
    public function get value():Number {
        
        return _value;
    }
    public function set value( tempValue:Number ):void {
        
        hSlider.value = tempValue;
        
        _value = Math.round( hSlider.value * Math.pow( 10, round ) ) / Math.pow( 10, round );
        
        if ( !isNaN( value ) )
            inputText.text = value.toString();
        
        dispatchEvent( new Event( Event.CHANGE ) );
    }
    private var _value:Number;
    
    
    
    /**
     * 
     * @param    parent
     * @param    xpos
     * @param    ypos
     * @param    text
     */
    public function InputTextAndHSlider(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0, text:String = ""):void
    {
        // inputText
        _inputText = new InputTextEx( parent, xpos, ypos, text );
        inputText.restrict = "-0-9.";
        
        // hSlider
        _hSlider = new HSliderEx( parent );
        hSlider.backClick = true;
        updateHSliderPosition( inputText );
        
        
        // inputText eventlistener
        inputText.addEventListener(Event.CHANGE, function( event:Event ):void {
                
                value = parseFloat( inputText.text );
            } );
        inputText.addEventListener(Component.DRAW, function( event:Event ):void {
                
                updateHSliderPosition( inputText );
            } );
        inputText.addEventListener(FocusEvent.FOCUS_OUT, function( event:FocusEvent ):void {
                
                if ( isNaN( value ) )
                    inputText.text = "0";
            } );
        
        // hSlider eventlistener
        hSlider.addEventListener(Event.CHANGE, function( event:Event ):void {
                
                value = hSlider.value;
            } );
    }
    
    
    
    /**
     * 
     * @param    component
     */
    private function updateHSliderPosition( component:Component ):void {
        
        hSlider.y = component.y + ( component.height - hSlider.height ) / 2;
        hSlider.x = ( component.x + component.width ) + ( hSlider.y - component.y );
    }
}



class ClearColorPanel extends Sprite {
    
    private var _backgroundColor:Number;
    public function get backgroundColor():Number { return _backgroundColor; }
    public function set backgroundColor(value:Number):void 
    {
        _backgroundColor = value;
        draw();
    }
    
    
    
    private var _backgroundAlpha:Number;
    public function get backgroundAlpha():Number { return _backgroundAlpha; }
    public function set backgroundAlpha(value:Number):void 
    {
        _backgroundAlpha = value;
        draw();
    }
    
    private var _width:Number;
    public override function get width():Number { return _width; }
    public override function set width(value:Number):void 
    {
        _width = value;
        draw();
    }
    
    private var _height:Number;
    public override function get height():Number { return _height; }
    public override function set height(value:Number):void 
    {
        _height = value;
        draw();
    }
    
    
    
    
    
    public function ClearColorPanel( x:Number = 0, y:Number = 0, width:Number = 0, height:Number = 0, alpha:Number = 1, backgroundColor:int = 0, backgroundAlpha:Number = 0.1 ) {
        
        this.x = x;
        this.y = y;
        _width = width;
        _height = height;
        this.alpha = alpha;
        _backgroundColor = backgroundColor;
        _backgroundAlpha = backgroundAlpha;
        
        draw();
    }
    
    public function draw():void {
        
        graphics.clear();
        graphics.beginFill( backgroundColor, backgroundAlpha );
        graphics.drawRect( 0, 0, width, height );
        graphics.endFill();
    }
}

class SlidePanel extends Sprite {
    
    private var panel:ClearColorPanel;
    private var openCloseSwitchButton:PushButton;
    private var open:Boolean;
    
    
    public override function set width(value:Number):void 
    {
        super.width = value;
        openCloseSwitchButton.x = width - 20;
    }
    
    
    public function SlidePanel( x:Number = 0, y:Number = 0, width:Number = 0, height:Number = 0, alpha:Number = 1, backgroundColor:int = 0, backgroundAlpha:Number = 0.1 ) {
        
        panel = new ClearColorPanel( x, y, width, height, alpha, backgroundColor, backgroundAlpha );
        super.addChild( panel );
        
        openCloseSwitchButton = new PushButton(super, width - 20, 0);
        super.addChild( openCloseSwitchButton );
        openCloseSwitchButton.width = 20;
        openCloseSwitchButton.addEventListener(MouseEvent.MOUSE_DOWN, openCloseSwitchButtonMouseDownHandler );
        
        openCloseSwitchButton.label = "-";
        open = true;
    }
    
    private function openCloseSwitchButtonMouseDownHandler( event:MouseEvent ):void {
        
        stage.addEventListener(MouseEvent.MOUSE_UP, stageMouseUpHandler );
        openCloseSwitchButton.addEventListener(MouseEvent.MOUSE_UP, openCloseSwitchButtonMouseUpHandler );
    }
    
    private function stageMouseUpHandler( event:MouseEvent ):void {
        
        stage.removeEventListener(MouseEvent.MOUSE_UP, stageMouseUpHandler);
        openCloseSwitchButton.removeEventListener(MouseEvent.MOUSE_UP, openCloseSwitchButtonMouseUpHandler);
    }
    
    private function openCloseSwitchButtonMouseUpHandler( event:MouseEvent ):void {
        
        openCloseSwitchButton.removeEventListener(MouseEvent.MOUSE_UP, openCloseSwitchButtonMouseUpHandler);
        
        // hide
        if ( open )
            show();
            
        // show
        else
            hide();
    }
    
    private function show():void {
        
        open = false;
        openCloseSwitchButton.label = "+";
        BetweenAS3.tween(panel, {y: -panel.height}, null, 0.5, Cubic.easeInOut ).play();
    }
    
    private function hide():void {
        
        open = true;
        openCloseSwitchButton.label = "-";
        BetweenAS3.tween(panel, { y: 0 }, null, 0.5, Cubic.easeInOut ).play();
    }
    
    
    override public function addChild(child:DisplayObject):DisplayObject 
    {
        return panel.addChild(child);
    }
    
    override public function addChildAt(child:DisplayObject, index:int):DisplayObject 
    {
        return panel.addChildAt(child, index);
    }
}