/**
 * Copyright potix2 ( http://wonderfl.net/user/potix2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zV8w
 */

// forked from potix2's Project Euler 1
//@see http://projecteuler.net/index.php?section=problems&id=6
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.events.Event;
    
    public class Euler extends Sprite {
        private function main():void {
        		var v:Vector.<int> = VectorUtil.range(1, 100);
        		var squareV:Vector.<int> = VectorUtil.map(v, function(item:int):int {
        			return item * item;
        		});
        		var s1:Number = VectorUtil.sum(squareV);
        		var s2:Number = VectorUtil.sum(v);
        		s2 *= s2;
        		log('answer=' + (s2 - s1));
        }
        
        // setup
    		private var _console:TextField;
        public function Euler() {
        		addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event):void {
        	    	_console = new TextField();
        	    	_console.multiline = true;
        	    	_console.selectable = true;
        	    	_console.autoSize = TextFieldAutoSize.LEFT;
        		addChild(_console);
        		main();
        }
         
        private function log(msg:String):void {
        		_console.appendText("\n" + msg);
        }
        
        private function dumpVector(v:Vector.<int>):void {
        		v.forEach(function (item:int, index:uint, vect:Vector.<int>):void {
        			this.log(item);
        		}, this);       	
        }
        
    }
}
class VectorUtil {
	public static function map(v:Vector.<int>, func:Function):Vector.<int> {
		var ret:Vector.<int> = new Vector.<int>(v.length);
		v.forEach(function(item:int, index:int, _v:Vector.<int>):void {
			ret[index] = func(item);
		});
		return ret;
	}
	
	public static function accumlate(v:Vector.<int>, init:int, func:Function):int {		
		var ret:int = init;
		v.forEach(function(item:int, index:int, vect:Vector.<int>):void {			ret = func(ret, item);
		});		return ret;
	}
	
	public static function sum(v:Vector.<int>):int {
		return VectorUtil.accumlate(v, 0, function(a:int, b:int):int { return a + b;	 	});
	}
	
	public static function range(min:int, max:int):Vector.<int> {
		var ret:Vector.<int> = new Vector.<int>(max - min + 1);
		var i:int = 0;
		while(i + min <= max ) {
			ret[i] = min + i;
			i++;
		}
		return ret;
	}
}

