/**
 * Copyright DaniilTutubalin ( http://wonderfl.net/user/DaniilTutubalin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zV7D
 */

    package
    {
        import flash.display.Sprite;
        import flash.text.TextField;
        import flash.utils.getTimer;
       
        public class TestLogarithm extends Sprite
        {
            private static const LOG2:Number = Math.log(2);
           
            private static const MAX_POW2:int = 1 << 31;
           
            private var field:TextField = new TextField();
           
            public function TestLogarithm()
            {
                super();
                test();
            }
           
            /**
             * Logarithm
             * Average per 1000 iterations: 0.483
             * Loop
             * Average per 1000 iterations: 0.544
             */
            private function test():void
            {
                var numbers:Vector.<int> = new Vector.<int>(1000);
                var timer:int, i:int, average:int, number:int;
                for (; i < 1000; i++)
                    numbers[i] = int(Math.random() * int.MAX_VALUE);
                super.addChild(field);
                field.width = 300;
                field.appendText("Logarithm\n");
               
                for (i = 0; i < 1000; i++)
                {
                    timer = getTimer();
                    for each (number in numbers)
                    {
                        nextPower2Log(number);
                    }
                    average += getTimer() - timer;
                }
               
                field.appendText(
                    "Average per 1000 iterations: " +
                    (average / 1000) + "\n");
               
                field.appendText("Loop\n");
                average = 0;
                for (i = 0; i < 1000; i++)
                {
                    timer = getTimer();
                    for each (number in numbers)
                    {
                        getNextPowerOfTwo(number);
                    }
                    average += getTimer() - timer;
                }
               
                field.appendText(
                    "Average per 1000 iterations: " + average / 1000);
            }
           
            private static function nextPower2Log(number:int):int
            {
                return 1 << (((Math.log(number) / LOG2) | 0) + 1);
            }
           
            private static function getNextPowerOfTwo(number:int):int
            {
                if (number > 0 && (number & (number - 1)) == 0)
                    return number;
                else
                {
                    var result:int = 1;
                    while (result < number && result < MAX_POW2)
                        result <<= 1;
                    return result;
                }
            }
        }
    }
