/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zUkS
 */

// forked from lizhi's GradientPenpackage
package
{
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.filters.DropShadowFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    /**
     * ...
     * @author lizhi http://game-develop.net/
     */
    public class TestDraw extends Sprite
    {
        private var lxl:Number;
        private var lyl:Number;
        private var lxr:Number;
        private var lyr:Number;
        private var lx:Number;
        private var ly:Number;
        private var bmd:BitmapData;
        private var offsets:Array = [new Point, new Point];
        
        public function TestDraw()
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, stage_mouseDown);
            addEventListener(Event.ENTER_FRAME, enterFrame);
            bmd = new BitmapData(stage.stageWidth, stage.stageHeight);
            scrollRect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
        }
        
        private function enterFrame(e:Event):void
        {
            filters = [new DisplacementMapFilter(bmd, new Point(), BitmapDataChannel.RED, BitmapDataChannel.RED,
            1, 120, DisplacementMapFilterMode.COLOR)];
            offsets[0].y+=3.5;
            offsets[1].y++;
            bmd.perlinNoise(10, 20, 3, 1, false, true, 1, true, offsets);
        
        }
        
        private function stage_mouseDown(e:MouseEvent):void
        {
            stage.addEventListener(MouseEvent.MOUSE_UP, stage_mouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMove);
            lx = lxl = lxr = mouseX;
            ly = lyl = lyr = mouseY;
        }
        
        private function stage_mouseMove(e:MouseEvent):void
        {
            drawLine(mouseX, mouseY);
        }
        
        private function stage_mouseUp(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_UP, stage_mouseUp);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMove);
        }
        
        public function drawLine(x:Number, y:Number):void
        {
            var hw:Number = 15;
            var matr:Matrix = new Matrix;
            var a:Number = Math.atan2(y - ly, x - lx) + Math.PI / 2;
           matr.createGradientBox(hw * 2, hw * 2, a+(x>lx?0:Math.PI), lx - hw, ly - hw);
            var dx:Number = hw * Math.cos(a);
            var dy:Number = hw * Math.sin(a);
            var xr:Number = x + dx;
            var yr:Number = y + dy;
            var xl:Number = x - dx;
            var yl:Number = y - dy;
            graphics.beginGradientFill(GradientType.LINEAR, [0, 0x900000, 0xff9900, 0xfffd8a, 0xffffff], [1, 1, 1, 1, 1], 
            [0, 0xff/4,0xff*2/4,0xff*3/4,0xff], matr);
            graphics.moveTo(lxr, lyr);
            graphics.lineTo(xr, yr);
            graphics.lineTo(xl, yl);
            graphics.lineTo(lxl, lyl);
            graphics.lineTo(lxr, lyr);
            graphics.endFill();
            
            lx = x;
            ly = y;
            lxr = xr;
            lyr = yr;
            lxl = xl;
            lyl = yl;
        }
    }

}