/**
 * Copyright Desuade ( http://wonderfl.net/user/Desuade )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zUJU
 */

// forked from Desuade's Desuade Partigen 2.1 Introduction Example Base File
// forked from mash's Desuade Partigen 2.1 Introduction Examples
/*

Desuade Partigen 2.1 Introduction Examples
http://desuade.com/partigen

This .fla goes over the basics of how to use Emitters with Partigen and the Desuade Motion Package

IMPORTANT!
Understanding of the Motion Package's MotionControllers is necessary. Working knowledge of the tween, sequencing, and physics classes is also highly recommended.
While it is possible to jump right in without it and be fine, this .fla assumes you are familiar with these before getting started.

////Overview////

This is an introduction to the Desuade Partigen API. It's recommended to have access to 
the official API docs as you're working along.

Partigen uses concepts (as well as the library itself) from the Motion Package such as 
MotionControllers heavily, as the DMP was designed with Partigen in mind.

In Partigen 1, there was a defined set of properties that could be changed for particles, 
with only a beginning and end value, and only a few offered random ranges. While this made 
it straightforward for novices, expert developers were looking for more freedom.

Thus the concept of MotionControllers was born, even before Partigen 1 was finished. This 
core architecture design allows for unlimited amount of tweens on each property during a 
particle's life - for any of the particle's tweenable properties.

While this comes with a bit more required code, much of it is duplicatable 
across emitters and provides incredible value. Also, since everything is dynamic, file 
size has decreased considerably, from the original default standard size of 40k, to an 
average of 20k (for all the libraries) - that includes and entire tween and physics engine, as 
well as the entire Partigen engine. The minimum is around 5k (this excludes controllers, etc).

If you're migrating from 1.x/AS2, there is very little in common with the old API besides 
some general concepts. Partigen 2 is a revolutionary new framework that's here to stay, 
with an architecture and syntax that is open to the future and community contributions.


////Usage////

Components of Partigen 2:

Renderers: these control how the particles are displayed
Pools: this manages the actual particle objects in memory
Events: particle events
Particles: these are dynamic objects that get created by emitters
Emitters: creates, manages, and configures particles


On average, the majority of your time with Partigen will be spent with emitters and their controllers.
Each emitter creates two "master controllers" by default:

emitter.controllers.emitter //this controls the properties of the emitter itself when start() is called
emitter.controllers.particle //this controls the properties of new particles


Any property under those will be the actual property being controlled.

For example:

emitter.controllers.particle.x //controls each particle's x value
emitter.controllers.particle.alpha //controls each particle's alpha value
emitter.controllers.emitter.x //controls the emitter's x value

-----

>To create emitter controllers, use one of the following methods on emitter.controllers.emitter:

addTween(property:String, duration:Number)
addPhysics(property:String, duration:Number, flip:Boolean = false)
addBeginValue(property:String, value:*, spread:* = 0, precision:* = 0, extras:* = null)

These methods will either create an EmitterTweenController or an EmitterePhysicsController
Each inherits a real MotionController or a PhysicsMultiController respectivly.


>To create particle controllers, use one of the following methods on emitter.controllers.particle:

addTween(property:String, duration:Number = 0)
addColorTween(property:String = "color", duration:Number = 0)
addPhysics(property:String, duration:Number = 0, flip:Boolean = false)
addBeginValue(property:String, value:*, spread:* = 0, precision:* = 0, extras:* = null)

These methods will either create a ParticleTweenController or a ParticlePhysicsController
Each resembles a MotionController or a PhysicsMultiController respectivly.


These controllers work the same way as MotionControllers from the Motion Package, so each 
one has a keyframes property than can be used to create more intricate effects:

emitter.controllers.particle.x.keyframes;

-----

The emitter has an angle and angleSpread property that is only used for ParticlePhysicsControllers
and will effect all Physics-based properties unless explicitly set not to via the 'useangle' property
on the given ParticlePhysicsController.


Emitters are controlled by start() and stop() methods, and do just what they say.
These methods also start and stop any controllers in my_emitter.controllers.emitter

-----

To make a custom Particle, simply create your class/Sprite/MovieClip and extend the partigen Particle class.
Then asign that class to the emitter:

my_em.particle = CustomParticle;


Consult the official API docs for more details http://api.desuade.com/. The examples in this .fla should provide a majority of common approaches.

*/

package {

	import flash.display.*;
	
	public class partigen_intro extends MovieClip {
	
		public function partigen_intro()
		{
			super();

			//you may want to disable debugging or set the level lower if the traces don't get overwhelming

			//fla setup
			stop();
			import flash.display.MovieClip;
			import flash.display.StageAlign;
			import flash.display.StageScaleMode;
			import flash.display.BitmapData;
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;

			//This is for all the debugging classes
			import com.desuade.debugging.*;
			import com.desuade.partigen.*;
			import com.desuade.motion.*;

			Debug.load(new DebugCodesPartigen()); //load partigen debug codes
			Debug.load(new DebugCodesMotion()); //load motion codes
			Debug.level = 50000;
			//Debug.enabled = true; //comment this out or set it to false to disable debugging
			//Debug.onlyCodes = true;

			import com.desuade.partigen.emitters.*;
			import com.desuade.partigen.particles.*;
			import com.desuade.partigen.controllers.*;
			import com.desuade.partigen.renderers.*;
			import com.desuade.partigen.pools.*;
			import com.desuade.partigen.events.*;

			import com.desuade.motion.eases.*;
			import com.desuade.motion.controllers.*
			import com.desuade.motion.events.*
			import com.desuade.utils.*


			var t1:MovieClip = new MovieClip(); //make a container for particles for the renderer
			addChild(t1);

			var sr:Renderer = new StandardRenderer(t1, 'top'); //by default, emitters create nullpools and nullrenderes. let's make a StandardRenderer to share between all of them

			////
			//this examples shows the new features introduced in Partigen 2.1
			//these include prefetching, particleBlendMode, and groupBitmap
			var em9:Emitter = new Emitter();
			em9.particle = CircleParticle;
			em9.renderer = sr;
			em9.eps = 5;
			em9.burst = 2;
			em9.groupAmount = 100; //in 2.1, group classes are removed and are integrated into Particle classes
			em9.groupProximity = 100;
			//uncomment this below to see the performance increase when using large groupAmount of vector particles
			em9.groupBitmap = true; //this takes the particle and turns it into a Bitmap, using that instead
			em9.particleBlendMode = 'subtract'; //this sets the blendmode for all the particles created
			em9.x = 40;
			em9.y = 150;
			em9.life = 2;
			em9.lifeSpread = 4;
			em9.controllers.particle.addBeginValue('x', '0', '200');
			em9.controllers.particle.x.keyframes.end.value = '200';
			em9.controllers.particle.x.keyframes.end.ease = 'easeInOutBounce';
			em9.start(3); //this starts the emitter as if it's already been running for the given amount of time
			//you may want to turn off debugging for this one!
			
		}
	
	}

}

import flash.display.Sprite;
class CircleParticle extends Sprite {
	public function CircleParticle() {
		super();
		this.graphics.beginFill(0x222222);
		this.graphics.drawCircle(0,0,5);
	}
}
