/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zTub
 */

package {
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.display.Sprite;
    import flash.events.Event;
    import com.bit101.components.HUISlider;
    import com.bit101.components.VUISlider;
    
    //[SWF(backgroundColor="0x000000")]
    public class FlashTest extends Sprite {
        private static var PIG_IMAGE:String = "http://assets.wonderfl.net/images/related_images/d/d3/d3b4/d3b433219e53b955f0e99b4cdb8f80cc2f1635f8";
        private var stipple:Stipple = new Stipple();
        private var bt:FileLoaderButton;
        private var hSlider:HUISlider;
        private var vSlider:VUISlider;
        
        public function FlashTest() {
            addChild(stipple);
            stipple.x = stage.stageWidth/2;
            stipple.y = stage.stageHeight/2;
            bt = new FileLoaderButton(stage, 10, 10, "load");
            bt.addEventListener(Event.COMPLETE, complete);
            bt.loader.load(new URLRequest(PIG_IMAGE), new LoaderContext(true));
            hSlider = new HUISlider(stage, 150, 18, "quality");
            hSlider.setSliderParams(1, 5, 3);
            vSlider = new VUISlider(stage, 420, 55, "scale", function change(event:Event):void{
                stipple.scaleX = stipple.scaleY = event.target.value;
            });
            
            vSlider.setSize(0, 350);
            vSlider.setSliderParams(0.5, 20, 1);
            vSlider.tick = 0.1;
        }
        
        private function complete(event:Event):void{
            stipple.clear();
            stipple.drawStipple(bt.data,350,350,hSlider.value);
        }

    }
}


import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.DisplayObjectContainer;
import flash.display.Loader;
import flash.display.Sprite;
import flash.display.Shape;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.FileReference;
import flash.net.FileFilter;
import com.bit101.components.PushButton;

//点描クラス
class Stipple extends Sprite{
    private var dotR:Shape = new Shape();
    private var dotG:Shape = new Shape();
    private var dotB:Shape = new Shape();

    public function Stipple(){
        addChild(dotR);
        addChild(dotG);
        addChild(dotB);
        dotR.blendMode = dotG.blendMode = dotB.blendMode = BlendMode.LIGHTEN;
    }
    
    //点描で描く
    public function drawStipple(source:BitmapData, width:Number = 100, height:Number = 100, quality:int = 1):void{
        graphics.beginFill(0x000000);
        graphics.drawRect(-width/2, -height/2, width, height);
        graphics.endFill();
        
        var r:uint = 0;
        var g:uint = 0;
        var b:uint = 0;
        var rgb:uint = 0;
        width *= 0.1*quality;
        height *= 0.1*quality;

        for(var i:int = -height/2; i < height/2; i++){
            for(var j:int = -width/2; j < width/2; j++){
                //RGBに分解
                rgb = source.getPixel(int((i+height/2)*source.width/width), int((j+width/2)*source.height/height));
                r = rgb & 0xFF0000;
                g = rgb & 0x00FF00;
                b = rgb & 0x0000FF;
                
                //各Shapeに描画
                dotR.graphics.beginFill(r);
                dotR.graphics.drawCircle((i)/(0.1*quality), (j-0.2)/(0.1*quality), 1.2);
                dotG.graphics.beginFill(g);
                dotG.graphics.drawCircle((i-0.2)/(0.1*quality), (j+0.2)/(0.1*quality), 1.2);
                dotB.graphics.beginFill(b);
                dotB.graphics.drawCircle((i+0.2)/(0.1*quality), (j+0.2)/(0.1*quality), 1.2);
            }
        }
    }
    
    public function clear():void{
        graphics.clear();
        dotR.graphics.clear();
        dotG.graphics.clear();
        dotB.graphics.clear();
    }
}

//ローカルから画像を取得するボタン
class FileLoaderButton extends PushButton{
    public var loader:Loader = new Loader();
    private var file:FileReference = new FileReference();
    private var fileFilter:FileFilter = new FileFilter("Images", "*.jpg;*.png;*.gif");
    
    public function FileLoaderButton(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number = 0, label:String = ""){
        super(parent, xpos, ypos, label, click);
        file.addEventListener(Event.SELECT, eventHandler);
        file.addEventListener(Event.CANCEL, eventHandler);
        file.addEventListener(Event.COMPLETE, eventHandler);
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, eventHandler);
    }
    
    private function click(event:MouseEvent):void{
        file.browse([fileFilter]);
    }
    
    private function eventHandler(event:Event):void{
        switch(event.type){
            case Event.SELECT:
                file.load();
            break;
            case Event.COMPLETE:
                if(event.target == file) {
                    loader.loadBytes(file.data);
                    return;
                }
            break;
        }
        dispatchEvent(event);
    }
    
    //ローカルから取得した画像をBitmapDataで返す
    public function get data():BitmapData{
        var bmd:BitmapData = new BitmapData(loader.width, loader.height);
        bmd.draw(loader);
        return bmd;
    }
}