/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zT4z
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=187
    public class Euler187 extends Sprite {
        private var _tf : TextField;
  
        public function Euler187() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText(solve().toString() + "\n");
            var g : int = getTimer();
            _tf.appendText((g - s).toString() + " ms\n");
        }
        
        private static function doEratosthenes(n : int) : Array
        {
            var ar : Vector.<uint> = new Vector.<uint>(n / 2 - 1);
            var i : int;
            for(i = 0;i < ar.length;i++)ar[i] = 1;
            
            var sq : int = (Math.sqrt(n) - 3) >> 1;
            for(var p : int = 0;p <= sq;p++){
                if(ar[p] == 1){
                    var m : int = 2 * p + 3;
                    for(var mm : int = m * m;mm <= n;mm += 2 * m){
                        ar[(mm - 3) >> 1] = 0;
                    }
                }
            }
            var ret : Array = [2];
            for(i = 0;i < ar.length;i++){
                if(ar[i] == 1)ret.push(2 * i + 3);
            }
            return ret;
        }
        
        private const N : int = 100000000;
        
        private function solve() : int
        {
            var primes : Array = doEratosthenes(N / 2);
            primes.push(N);
            var sq : int = Math.sqrt(N);
            var ct : int = 0;
            for(var i : int = 0;primes[i] <= sq;i++){
                // binary search
                var b : int = i;
                var e : int = primes.length;
                var mid : int = (b + e) >> 1;
                while(b < mid){
                    if(primes[i] * primes[mid] < N){
                        b = mid;
                    }else{
                        e = mid;
                    }
                    mid = (b + e) >> 1;
                }
                ct += (b + 1) - i;
                
                // linear search
                /*
                for(var j : int = i;primes[i] * primes[j] < N;j++);
//                _tf.appendText(b.toString() + " " + j.toString() + "\n");
                ct += j - i;
                */
            }
            return ct;
        }
    }
}




