/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zT0k
 */

package 
{
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
        
        private var ball:Sprite;
        private var particles:/*Particle*/Array;
        
        private var ballcanvas:BitmapData;
        private var edgecanvas:BitmapData;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            ball = new Sprite();
            //ball.graphics.lineStyle(1, 0);
            ball.graphics.beginFill(0xFFFFFF);
            ball.graphics.drawCircle(0, 0, 20);
            ball.graphics.endFill();
            

            
            edgecanvas = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild( new Bitmap(edgecanvas) );
            
            ballcanvas = new BitmapData(WIDTH,HEIGHT,true,0);
            addChild( new Bitmap(ballcanvas) );
            
            particles = new Array();
            for ( var i:int = 0; i < 100; i++ )
            {
                var p:Particle = new Particle();
                p.x = Math.random() * WIDTH;
                p.y = Math.random() * HEIGHT;
                p.mx = Math.random() - 0.5;
                p.my = Math.random() - 0.5;
                particles.push( p );
            }            
            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {

            
            ballcanvas.lock();
            ballcanvas.fillRect( ballcanvas.rect, 0 );
            for ( var i:int = 0; i < particles.length; i++ )
            {
                particles[i].x += particles[i].mx;
                particles[i].y += particles[i].my;
                if ( particles[i].x < 0 )    particles[i].x = WIDTH + particles[i].x;
                if ( particles[i].x >= WIDTH ) particles[i].x = particles[i].x % WIDTH;
                if ( particles[i].y < 0 )    particles[i].y = HEIGHT + particles[i].y;
                if ( particles[i].y >= HEIGHT ) particles[i].y = particles[i].y % HEIGHT;
                
                
                ballcanvas.draw( ball, new Matrix(1, 0, 0, 1, particles[i].x, particles[i].y) );
            }            
            ballcanvas.unlock();
            
            //    縁取り
            edgecanvas.lock();
            edgecanvas.fillRect( edgecanvas.rect, 0 );
            edgecanvas.applyFilter( ballcanvas, edgecanvas.rect, new Point(), new BlurFilter(8, 8, 1) );    //    ブラーフィルターをかけながら縁取り用のCanvasに描きこみ
            edgecanvas.colorTransform( edgecanvas.rect, new ColorTransform(0,0,0,0,100,100,100,255));        //    色を変更して不透過にすれば縁取りっぽくなる
            edgecanvas.unlock();
        }
        
    }
    
}

class Particle {
    public var x:Number;
    public var y:Number;
    public var mx:Number;
    public var my:Number;
}
