/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zSek
 */

// forked from shaktool's forked from: Peak
package {
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.utils.*;
	
	[SWF(width=465, height=465, frameRate=15, backgroundColor=0x000000)]
	public class Peak extends Sprite {
		private const WIDTH: int = 465;
		private const HEIGHT: int = 465;
		
		private var data: BitmapData = new BitmapData(WIDTH, HEIGHT, false , 0);
		
		public function Peak() {
			stage.addEventListener(MouseEvent.CLICK, generate);
			
			generate(null);
			var screen: Bitmap = new Bitmap(data);
			addChild(screen);
			var sprite: Sprite = new Sprite();
			addChild(sprite);
			sprite.graphics.beginFill(0xffffff, 0.3);
			//sprite.graphics.drawCircle(WIDTH / 2, HEIGHT / 2, 225);
			sprite.graphics.endFill();
		}
		
		public function generate(event: MouseEvent): void {
			data.lock();
			var mousePos: Number = mouseY / HEIGHT;
			var xStickinessInv: Number = 1.0 / 0.25;
			var yStickinessInv: Number = 1.0 / 1.0;
			var radius: Number = 0.5;
			var xRadius: Number = radius * xStickinessInv;
			var yRadius: Number = radius * yStickinessInv;
			for (var i: int = 0; i < WIDTH; i++) {
				for (var j: int = 0; j < HEIGHT; j++) {
					var gx: Number = xStickinessInv * (i / WIDTH);
					var gy: Number = yStickinessInv * (1.0 - j / HEIGHT);
					
					var value: Number;
					var red: int = 0;
					
					if (gx < gy - yRadius) value = gx;
					else if (gy < gx - xRadius) value = gy;
					else {
						var b: Number = (gy - gx) / yRadius;
						var m: Number = xRadius / yRadius;
						var cy: Number;
						if (m == 1) {
							cy = 0.5 * (b + 1.0);
						} else {
							cy = (m - Math.sqrt(b + m - b*m)) / (m - 1);
						}
						
						cy *= cy;
						value = gy - cy * yRadius;
					}
					
					if (value < 0.0) value = 0.0;
					if (value > 1.0) value = 1.0;
					var green: int = value * 255;
					var blue: int = (value > mousePos - 0.01 && value < mousePos + 0.01) ? 0xff : 0;
					data.setPixel(i, j, red * 0x10000 + green * 0x100 + blue);
				}
			}
			data.unlock();
		}
	}
}
