/**
 * Copyright terra1119 ( http://wonderfl.net/user/terra1119 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zRzB
 */

package {
	import flash.display.Sprite;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.events.Event;
	import net.hires.debug.Stats;
	
	public class Test extends Sprite {
		private var count:int = 100;
		private var gravity:Number = 0.5;
		private var wind:Number = 0.2;
		private var balls:Array;
		
		public function Test() {
			init();
		}
		
		private function init():void
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			balls = [];
			var i:int;
			for (i = 0; i < count; i++) {
				var ball:Ball = new Ball(5,Math.random()*0xffffff);
				ball.x = Math.random() * stage.stageWidth;
				ball.y = stage.stageHeight;
				ball.vx = Math.random() * 2 - 2;
				ball.vy = Math.random() * -10 - 10;
				addChild(ball);
				balls[i] = ball;
			}
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
                        addChild(new Stats());
		}
		
		private function onEnterFrame(e:Event):void 
		{
			var i:int;
			for (i = 0; i < balls.length; i++) {
				var ball:Ball = Ball(balls[i]);
				ball.vx += wind;
				ball.vy += gravity;
				ball.x += ball.vx;
				ball.y += ball.vy;
				if (ball.x - ball.radius > stage.stageWidth || ball.x + ball.radius < 0 || ball.y - ball.radius > stage.stageHeight || ball.y + ball.radius < 0) {
					ball.x = Math.random() * stage.stageWidth;
					ball.y = stage.stageHeight;
					ball.vx = Math.random() * 2 - 2;
					ball.vy = Math.random() * -10 - 10;
					wind = (rndNum(10, 0)) / 10;
					if (Math.random() < 0.5) {
						wind *= -1;
					}
				}
			}
		}
		
		private function rndNum(max:int, min:int):int {
			var num:int = Math.floor(Math.random() * (max - min + 1)) + min;
			return num;
		}
	}
}	

import flash.display.Sprite;
class Ball extends Sprite {
	public var radius:Number;
	public var color:uint;
	public var vx:Number;
	public var vy:Number;
	
	public function Ball(radius:Number=40,color:uint=0xff0000){
		this.radius = radius;
		this.color = color;
		init();
	}
		
	private function init():void{
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}
