/**
 * Copyright alexnotkin ( http://wonderfl.net/user/alexnotkin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zR77
 */

// forked from civet's Tree in the breeze
// forked from summerTree's flash on 2010-3-16
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Point;
    import flash.filters.GlowFilter;
    
    [SWF(backgroundColor="0xffffff", frameRate="25")]
    
    //绘制一棵树
    //@author 夏天的树人    
    public class Main extends Sprite
    {
        private var shape:Shape;
        private var source:BitmapData;
        
        public function Main()
        {
            shape = new Shape();
            //addChild(shape);
            source = new BitmapData(465, 465, false, 0xffffff);
            addChild(new Bitmap(source));
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            shape.graphics.clear();
            creatTree(shape.graphics, 232, 465, 90, 170, 5);
            creatTree(shape.graphics, 232, 465, 45, 100, 5);
            creatTree(shape.graphics, 232, 465, 105, 100, 5);
            step += (Math.PI/80) % Math.PI;
            
            source.fillRect(source.rect, 0xffffff);
            source.draw(shape);
        }
        
        private var step:Number = 0.0;
        private static const toRadian:Number = Math.PI / 150;
        
        //绘图对象，基本坐标px,py,角度，偏移长度，数量
        private function creatTree(g:Graphics,px:Number,py:Number,angle:Number,len:Number,n:int):void
        {
            if (n>-1)
            {
                angle += 3 * Math.cos(step) - 10;
                
                var x1:Number = px+0.1*len*Math.cos(angle * toRadian);
                var y1:Number = py-0.1*len*Math.sin(angle * toRadian);

                var x2:Number = px+len*Math.cos(angle * toRadian);
                var y2:Number = py-len*Math.sin(angle * toRadian);

                drawLine(g,n-1,px,py,x2,y2);

                var a_l:Number = angle + 20;
                var a_r:Number = angle - 10;

                len = len * 2/3;
                creatTree(g, x2, y2, angle - 3 * Math.sin(step), len,  n-1);
                creatTree(g, x1, y1, a_l, len*2/3, n-1);
                creatTree(g, x1, y1, a_r, len*2/3, n-1);
                creatTree(g, x2, y2, a_l, len*2/3, n-1);
                creatTree(g, x2, y2, a_r, len*2/3, n-1);
            }
        }
        //绘制线
        private function drawLine(g:Graphics,n:int,x1:Number,y1:Number,x2:Number,y2:Number):void
        {
            g.lineStyle(n,0x000000);
            g.moveTo(x1,y1);
            g.lineTo(x2,y2);
        }
    }
}