/**
 * Copyright royi ( http://wonderfl.net/user/royi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zQPD
 */

package {
    import flash.filters.DisplacementMapFilter;
    import flash.filters.BitmapFilter;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.*;
    import flash.events.*;
    import com.bit101.components.*;
    
    [SWF(width=465, height=465, frameRate=40)]
    public class Funky extends Sprite {
        private var g:Graphics;
        private var t:Number = 0;
        private var count:int = 1;
        private var debug:Label;
        private var sprite:Sprite = new Sprite();
        private var bmd:BitmapData;
        private var oldX:Number = 0, oldY:Number = 0;
        private var filter:BitmapFilter;
        private var sw:int, sh:int;
        private var noise:BitmapData;
        private var octaves:int = 2;
        private var offsets:Array = [];
        private var velocities:Array = [];
        private var seed:int;
        private var color:uint = 0xcc88ff;
        public function Funky() {
            sw = stage.stageWidth, sh = stage.stageHeight;
            debug = new Label(this);
            
            seed = Math.random() * int.MAX_VALUE;
            for (var i:int = 0; i < octaves; i++) {
                offsets[i] = new Point();
                velocities[i] = new Point(Math.random()*4-2, Math.random()*4-2);
            }

            noise = new BitmapData(sw, sh, false);
            //var noiseBmp:Bitmap = new Bitmap(noise);
            //addChild(noiseBmp);
            
            bmd = new BitmapData(sw, sh, false, 0x101020);
            var bmp:Bitmap = new Bitmap(bmd);
            addChild(bmp);
            
            //addChild(sprite);
            g = sprite.graphics;
            
            //filter = new BlurFilter(3,3,1);
            filter = new DisplacementMapFilter(noise, new Point(), 0, 1, 0, 1, "wrap", 0xff0000, 1);
            
            oldX = (Math.sin(t)+ Math.cos(t*.9))*100;
            oldY = (Math.cos(t)+ Math.sin(t*.6))*100;
            oldX += sw * .5;
            oldY += sh * .5;
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            t += .1;
            var x:Number = (Math.sin(t)+ Math.cos(t*.9))*100;
            var y:Number = (Math.cos(t)+ Math.sin(t*.6))*100;
            x += sw * .5;
            y += sh * .5;
            draw( x, y );
            oldX = x, oldY = y;
        }
        
        private function draw(x:Number, y:Number):void {
            for (var i:int = 0; i < octaves; i++) {
                offsets[i].x += velocities[i].x;
                offsets[i].y += velocities[i].y;
            }
            noise.perlinNoise(40, 40, octaves, seed, true, true, 15, false, offsets);
            g.clear();
            g.lineStyle(5, color);
            g.moveTo(oldX, oldY);
            g.lineTo(x, y);
            bmd.draw(sprite);
            bmd.applyFilter(bmd, bmd.rect, new Point(), filter);
            //bmd.scroll(0, 1);
            
            //debug.text = String(count);
        }
    }
}