/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zQAG
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.display.BlendMode;
    
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]
    
    public class FlashTest extends Sprite {
        private var timer:Timer;
        private static var interval:uint = 20;
        private static var rect:Rectangle = new Rectangle(212, 252, 40, 40);
        private static var ids:Array = [0, 0, 0, 0, 0, 0, 1, 1, 1, 2, 2, 3];
        private static var colors:Array = [0xFF0000, 0xFF9900, 0xFFFF00, 0xFFFFFF];
        private var particles:Array;
        
        public function FlashTest() {
            init();            
        }
        
        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            particles = new Array();
            start();
        }
        private function start():void {
            create();
            update();
            timer = new Timer(interval);
            timer.addEventListener(TimerEvent.TIMER, create, false, 0, true);
            timer.start();
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        
        private function stop():void {
            if(timer) {
                timer.stop();
                timer.removeEventListener(TimerEvent.TIMER, create);
            }
            removeEventListener(Event.ENTER_FRAME, update);
        }
        private function create(evt:TimerEvent = null):void {
            var fire:Fire = new Fire();
            var px:uint = rect.x + Math.floor(Math.random()*rect.width);
            var py:uint = rect.y + Math.floor(Math.random()*rect.height);
            fire.x = px;
            fire.y = py;
            addChild(fire);
            particles.push(fire);
            var colorTrans:ColorTransform = new ColorTransform(0,0,0,1,0,0,0,0);
            var id:uint = ids[Math.floor(Math.random()*(ids.length+1))];
            colorTrans.color = colors[id];
            fire.transform.colorTransform = colorTrans;
            fire.blendMode = BlendMode.ADD;
        }
        private function update(evt:Event = null):void {
            for(var n:uint = 0; n < particles.length; n++) {
                var fire:Fire = particles[n];
                fire.update();
                if(fire.life > 1) {
                    particles.splice(n, 1);
                    fire = null;
                }
            }
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class Fire extends Sprite {
    private var base:Shape;
    private static var _width:uint = 32;
    private static var _height:uint = 64;
    private static var yOffset:int = -4;
    private var basePos:int = 0;
    private static var targetPos:int = -100;
    public var life:Number = 0;
    private static var speed:Number = 0.05;
    private var count:uint = 0;
    private static var bColor:uint = 0xFFFFFF;
    
    public function Fire() {
        if(stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }
    
    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        basePos = y;
        draw();
    }
    public function update():void {
        life += speed;
        y = basePos + targetPos * life;
        alpha = 1 - life;
        blink();
    }
    
    private function blink():void {
        if(count%4 < 2) {
            visible = true;
        } else {
            visible = false;
        }
        count ++;
    }
    private function draw():void {
        base = new Shape();
        addChild(base);
        var colors:Array = [bColor, bColor];
        var alphas:Array = [1, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(_width, _height, 0, -_width*0.5, -_height*0.5 + yOffset);
        base.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        base.graphics.drawEllipse(-_width*0.5, -_height*0.5+yOffset, _width, _height);
        base.graphics.endFill();
    }



    


}
