/**
 * Copyright nitoyon ( http://wonderfl.net/user/nitoyon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zPbq
 */

// beginBradientFill() の透明度はマスクに反映されない？
// → 解決しました！！！　ありがとうございます
//
// 答えはこちらの Fork に：
// http://wonderfl.net/code/e1f5ec6457d8811ae010af206bf39b77e30cb5ce
// 「cacheAsBitmap」するのが重要だったようです。
//
//
//
//
//------------------------------------------------------------
//   上： マスクに利用するSprite
//   下： マスクした結果
//       →グラデーションでマスクされてほしいのに、べったりと切り取られてる...
//------------------------------------------------------------
// マスクを作るときに beginGradientFill() の透明度情報を使えると嬉しい
// んだけど、どうもできない気配がある。
// すっきり実装する方法はないものか。もちろん、BitmapData を使ったり、
// for 文を使ってマスク画像を作ればグラデーションでマスクを実装はできるんだけど
// 実装はめんどくさいし、コードが冗長になる。
package {
    import flash.display.Sprite;
    import flash.geom.Matrix;

    public class FlashTest extends Sprite {
        public function FlashTest() {
            // マスク画像を作成する
            var msk1:Sprite = createMask();
            addChild(msk1);

            // 赤い Sprite を作成する
            var canvas:Sprite = new Sprite();
            canvas.graphics.beginFill(0xff0000);
            canvas.graphics.drawRect(0, 0, 400, 400);
            canvas.graphics.endFill();
            addChild(canvas);

            // 赤い Sprite のマスクを利用する...
            // マスクに透明度が反映されてほしいが、アルファ1でマスクされる!!
            var msk2:Sprite = createMask();
            msk2.y = 80;
            canvas.mask = msk2;
        }
        
        private function createMask():Sprite{
            // Matrix を作成
            var mtx:Matrix = new Matrix();
            mtx.createGradientBox(300, 40);
            
            // マスクを作成
            var msk:Sprite = new Sprite();
            msk.graphics.beginGradientFill("linear", 
                [0x00ff00, 0x00ff00],
                [1, 0],
                [0, 255],
                mtx);
            msk.graphics.drawRect(0, 0, 300, 40);
            msk.graphics.endFill();
            
            return msk;
        }
    }
}