/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zOwM
 */

// forked from tkinjo's Star Class
package
{
    import flash.display.*;
    import flash.events.*;
    
    [SWF(width="465", height="465", backgroundColor="0x0", frameRate="60")] 
    /**
     * Star Brush
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private const STAR_NUM_VERTEX:uint = 5;
        private const STAR_OUTER_RADIUS:uint = 7;
        private const STAR_INNER_RADIUS:uint = 3;
        private const FADE_STEP:Number = 0.01;
        private const DIFFUSION_RADIUS:Number = 50;
        private const STAR_FILL:GraphicsSolidFill = new GraphicsSolidFill( 0xffffff );
        
        private var stageWidth:Number = stage.stageWidth;
        private var stageHeight:Number = stage.stageHeight;
        
        private var stars:Vector.<Star>;
        
        public function Main() 
        {
            stars = new Vector.<Star>();
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, stageMouseMoveHandler);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function createStar():Star {
            
            return new Star( STAR_NUM_VERTEX, STAR_OUTER_RADIUS, STAR_INNER_RADIUS, STAR_FILL );
        }
        
        private function stageMouseMoveHandler( event:MouseEvent ):void {
            
            var star:Star = new Star( STAR_NUM_VERTEX, STAR_OUTER_RADIUS, STAR_INNER_RADIUS, STAR_FILL );
            
            var diffusionAngle:Number = Math.random() * Math.PI * 2;
            var diffusionRadius:Number = Math.random() * DIFFUSION_RADIUS;
            star.x = event.stageX + Math.sin( diffusionAngle ) * diffusionRadius;
            star.y = event.stageY + Math.cos( diffusionAngle ) * diffusionRadius;
            
            star.rotation = Math.random() * 360;
            
            
            
            stars.push( star );
            addChild( star );
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            for ( var i:uint = 0; i < stars.length; i++ ) {
                
                stars[i].scaleX -= FADE_STEP;
                stars[i].scaleY -= FADE_STEP;
                stars[i].alpha  -= FADE_STEP;
            }
            
            while ( stars.length != 0 && stars[0].scaleX < 0 ) {
                
                removeChild( stars[0] );
                stars.shift();
            }
        }
    }
}



/** --------------------------------------------------
 * Star Class
 *///*
import flash.display.*;
import flash.geom.*;
//*/
class Star extends Sprite {
    
    /**
     * 
     */
    public function get numVertex():uint { return _numVertex; }
    public function set numVertex(value:uint):void 
    {
        _numVertex = value;
        draw();
    }
    private var _numVertex:uint;
    
    
    /**
     * 
     */
    public function get outerRadius():Number { return _outerRadius; }
    public function set outerRadius(value:Number):void 
    {
        _outerRadius = value;
        draw();
    }
    private var _outerRadius:Number;
    
    
    
    /**
     * 
     */
    public function get innerRadius():Number { return _innerRadius; }
    public function set innerRadius(value:Number):void 
    {
        _innerRadius = value;
        draw();
    }
    private var _innerRadius:Number;
    
    
    
    /**
     * 
     */
    public function get fill():IGraphicsData { return _fill; }
    public function set fill(value:IGraphicsData):void 
    {
        _fill = value;
        draw();
    }
    private var _fill:IGraphicsData;
    
    
    
    /**
     * 
     */
    public function get stroke():IGraphicsData { return _stroke; }
    public function set stroke(value:IGraphicsData):void 
    {
        _stroke = value;
        draw();
    }
    private var _stroke:IGraphicsData;
    
    
    
    /**
     * 
     */
    public function Star( numVertex:uint, outerRadius:Number, innerRadius:Number, fill:IGraphicsData = null, stroke:IGraphicsData = null ):void {
        
        _numVertex   = numVertex;
        _outerRadius = outerRadius;
        _innerRadius = innerRadius;
        _fill        = fill;
        _stroke      = stroke;
        
        draw();
    }
    
    private function draw():void {
        
        graphics.clear();
        
        var drawGraphicsData:Vector.<IGraphicsData> = Vector.<IGraphicsData>([ fill, stroke ]);
        
        
        
        // path
        var exteriorAngle:Number = Math.PI * 2 / numVertex;
        
        var pathData:Vector.<Point> = new Vector.<Point>();
        
        for ( var i:uint = 0; i < numVertex; i++ ) {
            
            pathData.push( new Point( Math.sin( exteriorAngle * i - ( exteriorAngle / 2 ) ) * outerRadius, 0 + Math.cos( exteriorAngle * i - ( exteriorAngle / 2 ) ) * outerRadius ) );
            pathData.push( new Point( Math.sin( exteriorAngle * i ) * innerRadius, Math.cos( exteriorAngle * i ) * innerRadius ) );
        }
        
        var path:GraphicsPath = createGraphicsPathAtData( pathData );
        drawGraphicsData.push( path );
        
        
        
        // draw
        graphics.drawGraphicsData( drawGraphicsData );
    }
}



function createGraphicsPathAtData( pathData:Vector.<Point> ):GraphicsPath 
{
    var commands:Vector.<int> = new Vector.<int>();
    var data:Vector.<Number> = new Vector.<Number>();
    
    var pathDataLength:int = pathData.length; 
    
    for ( var i:uint = 0; i < pathDataLength; i++ ) {
        
        if( i != 0 )
            commands.push( GraphicsPathCommand.LINE_TO );
        else if( i == 0 )
            commands.push( GraphicsPathCommand.MOVE_TO );
        
        data.push( pathData[i].x, pathData[i].y );
    }
    
    commands.push( GraphicsPathCommand.LINE_TO );
    data.push( pathData[0].x, pathData[0].y );
    
    return new GraphicsPath( commands, data );
}