/**
 * Copyright saharan ( http://wonderfl.net/user/saharan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zOWH
 */

/*
 * ここのサイト様の背景をAS3で
 * http://www.s5-style.com/
 * 
 * proposer:http://wonderfl.net/user/ProjectNya
 */
package {
    import flash.text.TextField;
    import flash.events.*;
    import flash.display.*;
    [SWF(frameRate = 60)]
    public class CircleBG extends Sprite {
        private var circleFirst:Circle;
        //private var debug:TextField;
        private var rise:Boolean;
        private var riseCount:int;
        private var nextRiseCount:int;

        public function CircleBG() {
            initialize();
        }

        private function initialize():void {
            riseCount = 0;
            nextRiseCount = (int)(Math.random() * 100 + 400);
            graphics.beginFill(0xf5f5f5);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            addEventListener(Event.ENTER_FRAME, frame);
            for(var i:int = 0; i < 300; i++)
                frame(null);
            //debug = new TextField();
            //debug.width = 256;
            //addChild(debug);
        }

        private function frame(e:Event):void {
            if(Math.random() > 0.8)
                addCircle(new Circle(Math.random() * stage.stageWidth + 50, stage.stageHeight + 50));
            var c:Circle = circleFirst;
            var count:int = 0;
            while(c != null) {
                if(c.chase) {
                    var dx:Number = mouseX + c.offsetx - c.x;
                    var dy:Number = mouseY + c.offsety - c.y;
                    var length:Number = Math.sqrt(dx * dx + dy * dy);
                    c.distToTraget = length;
                    length = 1 / length * 2;
                    dx *= length;
                    dy *= length;
                    c.vx = dx;
                    c.vy = dy;
                    if(c.chaseCount > (rise ? 150 : 300))
                        c.chase = false;
                    c.chaseCount++;
                }
                c.move(rise ? 10 : 1);
                if(c.py < -50)
                    removeCircle(c);
                c = c.next;
                count++;
            }
            //debug.text = "NumCircles:" + count + " isRise:" + rise;
            riseCount++;
            if(riseCount > nextRiseCount) {
                rise = !rise;
                riseCount = 0;
                nextRiseCount = (int)(Math.random() * 100 + 400);
            }
        }

        private function addCircle(circle:Circle):void {
            if(circleFirst == null)
                circleFirst = circle;
            else {
                circle.prev = circleFirst;
                circle.next = circleFirst.next;
                if(circleFirst.next != null)
                    circleFirst.next.prev = circle;
                circleFirst.next = circle;
            }
            addChild(circle);
        }

        private function removeCircle(circle:Circle):void {
            if(circle == circleFirst)
                circleFirst = circle.next;
            else {
                if(circle.prev != null)
                    circle.prev.next = circle.next;
                if(circle.next != null)
                    circle.next.prev = circle.prev;
            }
            removeChild(circle);
        }

    }
}

import flash.geom.*;
import flash.display.*;
class Circle extends Sprite {
    public var px:Number;
    public var py:Number;
    public var vx:Number;
    public var vy:Number;
    public var offsetx:Number;
    public var offsety:Number;
    public var size:Number;
    public var sizeMul:Number;
    public var angle:Number;
    public var vangle:Number;
    public var distToTraget:Number;
    public var chase:Boolean;
    public var form:Matrix;
    public var color:uint;
    public var chaseCount:int;
    public var next:Circle;
    public var prev:Circle;
    
    public function Circle(x:Number, y:Number) {
        vangle = 0;
        prev = next = null;
        px = x;
        py = y;
        vx = Math.random() - 0.5;
        vy = 0;
        var len:int = Math.random() * 64;
        distToTraget = 50;
        offsetx = 0.8 * len;
        offsety = 0.3 * len;
        chase = Math.random() > 0.5;
        size = Math.random() * 5;
        sizeMul = 0.99 - Math.random() * 0.02;
        color = (int)(Math.random() * 128 + 0.5) << 16 |
            (int)(Math.random() * 128 + 0.5);
        graphics.clear();
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, 1);
        graphics.endFill();
        form = new Matrix();
        angle = 0;
    }
    
    public function move(gravity:Number):void {
        size *= sizeMul;
        if(size < 0.5)
            size = chase ? 8 : 4;
        if(chase) {
            vangle += 0.2 / distToTraget;
            gravity = 0;
        }
        angle += vangle;
        vangle *= 0.95;
        vx -= Math.random() * 0.01 * gravity;
        vy -= 0.015 * gravity;
        px += vx;
        py += vy;
        form.identity();
        form.scale(size + 1, size + 1);
        form.translate(-12, 0);
        form.rotate(angle);
        form.translate(12, 0);
        form.translate(px, py);
        transform.matrix = form;
    }
}
