/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zOKE
 */

// forked from yd_niku's Stardust Stream
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;
    import frocessing.display.F5MovieClip2DBmp;
    [SWF(frameRate=60)]
    public class FlashTest extends F5MovieClip2DBmp {
        
        private var _particles:Vector.<Star>;
        public function FlashTest() {
        }
        public function setup():void {
            //キャンバスのサイズ指定
            size( 465, 465 );
            //背景の描画
            background( 0 );
            //HSV
            colorMode( HSV, 1 );
                
            const LEN:int = 1000;
            _particles = new Vector.<Star>();
            for( var i:int=0; i<LEN; ++i ) {
                var angle :Number = Math.PI*2*Math.random();
                var radius:Number = 232*Math.random();
                _particles.push( new Star(Math.cos(angle)*radius+232,Math.sin(angle)*radius+232) );
            }
            stage.addEventListener(MouseEvent.MOUSE_DOWN,reset);
        }
        private function reset(e:Event):void{
            
            for each( var p:Star in _particles ){
                var angle :Number = Math.PI*2*Math.random();
                var radius:Number = 232*Math.random();
                p.x = Math.sin(angle)*radius + mouseX;
                p.y = Math.cos(angle)*radius + mouseY;
                p.vx = ( p.x - mouseX )*0.2;
                p.vy = ( p.y - mouseY )*0.2;
            }

        }

        public function draw():void{
            beginFill(0x006699,0.9);
            drawRect(0,0,465,465);
            endFill();
            
            noiseSeed(random(100));
            noise(random(465),random(465));
            
            var xx:Number, yy:Number;
            for each( var p:Star in _particles ){
                xx = p.x;
                yy = p.y;
                p.vx += ( mouseX - p.x ) * 0.002 + (Math.random()-0.5)*0.1;
                p.vy += ( mouseY - p.y ) * 0.002 + (Math.random()-0.5)*0.1;
                
                p.x += p.vx*p.mass;
                p.y += p.vy*p.mass;
                
                p.vx *= 0.99; 
                p.vy *= 0.99;
                
                stroke(random(0.2,0.8), 0.5,1);
                line( xx, yy, p.x, p.y );
                
            }       
        }
    }
}

class Star{
    public var x:Number;
    public var y:Number;
    public var vx:Number =0;
    public var vy:Number =0;
    public var mass:Number =0;
    public function Star(sx:Number,sy:Number){
        x = sx;
        y = sy;
        mass = Math.random()*0.4+0.4;
    }
}

