/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zNxw
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    import flash.geom.*;
    // @see http://projecteuler.net/index.php?section=problems&id=
    public class Euler extends Sprite {
        private var _tf : TextField;
  
        public function Euler() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText(solve(500).toString() + "\n");
            var g : int = getTimer();
            _tf.appendText((g - s).toString() + " ms\n");
        }
        
        private var _ts : Array;
        
        private function generatePoints(n : int) : Array
        {
            var ret : Array = [];
            var s : Number = 290797;
            for(var i : int = 0;i <= n;i++){
                s = (s * s) % 50515093;
                var t0 : int = (s % 2000) - 1000;
                s = (s * s) % 50515093;
                var t1 : int = (s % 2000) - 1000;
                
                ret.push(new Point(t0, t1));
            }
            return ret;
        }
        
        private function solve(N : int) : int
        {
            _ts = generatePoints(N);
            for each(var p : Point in _ts){
//                _tf.appendText("" + p + "\n");
            }
            
            var i : int, j : int, k : int;
            for(i = 0;i < N;i++){
                for(j = 0;j < N;j++){
                    if(i == j)continue;
                    for(k = j + 1;k < N;k++){
//                        if(i == j || i == k)continue;
                        var ip : int = 
                            (_ts[j].x - _ts[i].x) * (_ts[k].y - _ts[i].y) -
                            (_ts[j].y - _ts[i].y) * (_ts[k].x - _ts[i].x);
                        if(ip > 0){
//                            _tf.appendText("" + i + "," + j + "," + k + "," + 0.5 * ip + "\n");
                        } 
                    }
                }
            }
            return 0;
        }
    }
}