/**
 * Copyright alexchirila87 ( http://wonderfl.net/user/alexchirila87 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zNdC
 */

// forked from Heo.SangHun's forked from: 領域分割
//forked from kkeisuke 's 영역 분할
package 
{
    import caurina.transitions.Tweener;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.Timer;
    
    
    /**
    * 스테이지 영역을 사각형으로 분할. 이것을 재귀는 것입니까?
    * 너무 잘되지 않는 부분도있는 것. .
    *
    * http://www.kenjiroharigai.com/
    * 상기를 실현하고자합니다. 그러나, 위에는 사각형있다. .
    *
    * 아래 참고시키고 받았습니다. 감사합니다.
    * http://beautifl.net/?c=fractal
    */
    [SWF(backgroundColor = 0xFFFFFF, frameRate = 40, width = 700, height = 1000)]
    public class AreaSplit extends Sprite 
    {
        private var rectDataes:/*Rectangle*/Array;
        
         //삭제 Rectangle 인스턴스를 포함하는 배열
        private var allRectDataes:/*Rectangle*/Array;
        private var boxes:/*Box*/Array;
        private var count:int;
        private var w:Number;
        private var h:Number;
        private var endP:Point;
        
        //반복 함수
        private var func:Function = splitsArea;
        private var timer:Timer = new Timer(200, 1);
        
        private const PROBABILITY:Number = .7;
        private const MIN:int = 15;
        private const MAX:int = 300;
        private const SPEED:Number = 0.01;
        
        
        public function AreaSplit():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            setUp();
            
            func();
        }
        
        
        private function setUp():void 
        {
            allRectDataes = [];
            boxes = [];
            count = 0;
            rectDataes = [new Rectangle(0, 0, stage.stageWidth, stage.stageHeight)];
            w = stage.stageWidth / 2;
            h = stage.stageHeight / 2;
            endP = new Point(rectDataes[0].left, rectDataes[0].bottom);
        }
        
        
        private function splitsArea():Function
        {
            var parent:Rectangle = rectDataes[0];
            
            var leftBottom:Point = new Point(parent.left, parent.bottom);
            
            //MIN 당분간까지 스킵하지 않는다.
            if (count < MIN || Math.random() >= PROBABILITY)
            {
                rectDataes.shift()
                rectDataes.push(new Rectangle(parent.x, parent.y, w, h));
                rectDataes.push(new Rectangle(parent.x + w, parent.y, w, h));
                rectDataes.push(new Rectangle(parent.x + w, parent.y + h, w, h));
                rectDataes.push(new Rectangle(parent.x, parent.y + h, w, h));
                
            }else 
            {
                  //카운트를 건너
                count++
                
                //삭제된 녀석을 넣는다
                allRectDataes.push(rectDataes.shift());
            }
            
             //이 시점에 오면, w, h를 더 반으로한다.
            if (leftBottom.x == endP.x && leftBottom.y == endP.y) 
            {
                w /= 2;
                h /= 2;
            }
            
            if (count < MAX) 
            {
                count++
                
                return func();
                
            }else 
            {
                 //마지막 배열을 정리한다.
                allRectDataes = allRectDataes.concat(rectDataes);
                setBox();
                trace("end");
                return new Function();
            }
        }
        
        
        private function setBox():void
        {
            var n:int = allRectDataes.length;
            for (var i: int = 0; i < n; i++) 
            {
                var box:Box = new Box(allRectDataes[i], i);
                box.alpha = 0;
                this.addChild(box);
                
                boxes.push(box);
                if(box.x  > (40 + Math.random()*0) && box.x < (400 - Math.random()*0))
                Tweener.addTween(box, { alpha:.5, time:SPEED, delay:SPEED * i + SPEED, transition:"linear", onComplete:complete, onCompleteParams:[box] } );
            }    
        }
        
        
        private function complete(box:Box):void
        {
            box.addEventListener(MouseEvent.CLICK , reSet);
            box.buttonMode = true;
        }
        
        
        private function reSet(e:MouseEvent):void 
        {
            Tweener.removeAllTweens();
            
            var n:int = boxes.length;
            for (var i: int = 0; i < n; i++) 
            {
                boxes[i].buttonMode = false;
                this.removeChild(boxes[i]);
            }
            
            //조금 시작을 연기한다.
            timer.addEventListener(TimerEvent.TIMER_COMPLETE , reStart);
            timer.reset();
            timer.start();
        }
        
        
        private function reStart(e:TimerEvent):void 
        {
            timer.removeEventListener(TimerEvent.TIMER_COMPLETE , reStart);
            
            setUp();
            
            func();
        }
        
    }
    
}



import flash.display.BlendMode;
import flash.display.Sprite;
import flash.geom.Rectangle;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;


class Box extends Sprite
{
    static private var textFormat:TextFormat = new TextFormat("_sans", 11, 0);
    
    private const FILL_COLOR:uint = 0x336699;
    private const LINE_COLOR:uint = 0x666666;
    private const MIN_ALPHA:Number = 0.3;
    
    
    public function Box(rect:Rectangle, num:int):void 
    {
        this.graphics.beginFill(FILL_COLOR, Math.max(Math.random(), MIN_ALPHA));
        this.graphics.lineStyle(1, LINE_COLOR, 1, true);
        this.graphics.drawRect(0, 0, rect.width, rect.height);
        this.graphics.endFill();
        this.x = rect.x;
        this.y = rect.y;
        
        var tf:TextField = new TextField();
        tf.defaultTextFormat = textFormat;
        tf.selectable = false;
        tf.mouseEnabled = false;
        tf.blendMode = BlendMode.LAYER;
        //tf.text = String(num);
        tf.autoSize = TextFieldAutoSize.LEFT
        tf.x = (this.width - tf.width) * 0.5;
        tf.y = (this.height - tf.height) * 0.5;
        this.addChild(tf);
    }
    
}