/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zMnq
 */

package  
{
    import com.bit101.components.PushButton;
    import com.bit101.components.Text;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import jp.progression.commands.lists.LoaderList;
    import jp.progression.commands.lists.SerialList;
    import jp.progression.commands.net.LoadSWF;
    
    /**
     * Progressionでの読み込みエラー処理のテスト
     * 
     * LoaderListをSerialListにいれた場合のエラーハンドリングの仕方がよくわからない。
     * LoaderList単体ではエラーキャッチできるけど、SerialListの中にいれたときはどうすればよい？？
     * 
     * 
     * [Only LoaderList]をクリックした場合は、エラーメッセージが下に出力される。
     * 
     * [LoaderList With SerialList]をクリックした場合、このままだとブラウザクラッシュするので注意
     */
    public class ErrorCatchTest extends Sprite 
    {
        private var _button0:PushButton;
        private var _button1:PushButton;
        private var _text0:Text;
        private var _text1:Text;
        
        public function ErrorCatchTest() 
        {
            _button0 = new PushButton(this, 10, 10, "Only LoaderList", onlyLoaderListHandler);
            _button1 = new PushButton(this, 220, 10, "LoaderList With SerialList", withSerialListHandler);

            _text0 = new Text(this, 10, 40, "");
            _text1 = new Text(this, 220, 40, "");
            
            _button0.width = _button1.width = 200;
        }
        
        private function onlyLoaderListHandler(e:MouseEvent):void 
        {
            var com:LoaderList = new LoaderList( {
                catchError:function(target:Object, error:Error):void
                {
                    _text0.textField.appendText("LoaderList:catchError\n")
                }
                ,onError:function():void
                {
                    _text0.textField.appendText("LoaderList:catchError\n")
                }
                ,onComplete:function():void
                {
                    _text0.textField.appendText("LoaderList:Complete\n")
                }
            } );
            com.addCommand(new LoadSWF(new URLRequest("http://assets.wonderfl.net/images/related_images/c/ce/ce16/ce162c9e23acb069c631df66fb01ba8c4ab2174"),null
            ,{
                catchError:function(target:Object, error:Error):void
                {
                    _text0.textField.appendText("LoadSWF:catchError\n")
                }
                ,onError:function():void
                {
                    _text0.textField.appendText("LoadSWF:onError\n")
                }
            }))
            com.execute();
        }
        
        private function withSerialListHandler(e:MouseEvent):void 
        {
            var sList:SerialList = new SerialList();
            sList.addCommand(
                function():void
                {
                    var com:LoaderList = new LoaderList( {
                        catchError:function(target:Object, error:Error):void
                        {
                            _text1.textField.appendText("LoaderList:catchError\n")
                        }
                        ,onError:function():void
                        {
                            _text1.textField.appendText("LoaderList:catchError\n")
                        }
                        ,onComplete:function():void
                        {
                            _text1.textField.appendText("LoaderList:Complete\n")
                        }
                    } );
                    this.parent.insertCommand(com);
                    com.addCommand(new LoadSWF(new URLRequest("http://assets.wonderfl.net/images/related_images/c/ce/ce16/ce162c9e23acb069c631df66fb01ba8c4ab2174"),null
                    ,{
                        catchError:function(target:Object, error:Error):void
                        {
                            _text1.textField.appendText("LoadSWF:catchError\n")
                        }
                        ,onError:function():void
                        {
                            _text1.textField.appendText("LoadSWF:onError\n")
                        }
                    }))
                }
            )
            sList.execute();
        }
    }
}