/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zLc1
 */

// forked from Millers7's Pixel Explosion
/**7777777777777777777777777777777777777777777777777
7     ____________
7    |\___________\    
7    ||           |    Millers7 Development
7    ||  77       |      
7    ||   77      |    PixelBitmap
7    ||     77    |    
7    ||       77  |    IN PRODUCTION  
7    ||  7777777  |    
7    \|___________|    
7
7    @author: Elwin Arens, Millers7
7    @date: August 2010
7    @email: elwin@millers7.com
7    @website: http://www.millers7.com
7 
77777777777777777777777777777777777777777777777777*/

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;


    public class PixelBitmap extends Sprite {
        
        private const _url:String = "http://www.promocionarte.info/APPS/aksoral/app_full_proxy.jpg";
        
        
        /**
         * Vectors for holding pixeldata
         */
        private var _pixels:PixelData = new PixelData();
        
        public var _random:Vector.<Point> = new Vector.<Point>();
               
        private var _bmp:Bitmap;
        private var _bmpd:BitmapData;   
        private var _bmp2:Bitmap;
        private var _bmpd2:BitmapData;   


        private var _loader:Loader = new Loader();   
        
        private var _count:int; 
        
        private var _offsetX:Number = 0.1;
        private var _interpol:Number = 1.0;
        
        private var _blur:BlurFilter;
        private var _colormatrix:ColorMatrixFilter;
        private var _rect:Rectangle;
        private var _rate:Number = 0.95;
        private var _deg:int = 0;
        private var _isgrowing:Boolean = true;
        
        private var _trace:TextField = new TextField();
        
        private var _cC:int = 150;
        
        private var _prev_f:Number;
                   
        public function PixelBitmap()
        {
            //filters
            _blur = new BlurFilter(1.1,1.1,1);
            _trace.width = 300;
            _trace.textColor = 0xFF0000;
            _colormatrix = new ColorMatrixFilter([
               _rate,0,0,0,1,
               0,_rate,0,0,1,
               0,0,_rate,0,1,
               0,0,0,_rate,
            ]);
            
            stage.frameRate = 60;            
            //these are for the applyFilter method
            _rect = new Rectangle(0,0,500,500);

            configureAssets();
        }

        private function configureAssets():void
        {
            
            stage.quality = "LOW";
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
            _loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);

            var request:URLRequest = new URLRequest(_url);
            _loader.x = 100;
            _loader.y = 100;
            _loader.load(request, new LoaderContext(true));
            _loader.name = 'test';                   
                        
        }

        private function completeHandler(event:Event):void 
        {
            _bmpd = new BitmapData(500,500);
             _bmp = new Bitmap(_bmpd);
            _bmpd2 = new BitmapData(500,500,false,0xFFFFFF);
             _bmp2 = new Bitmap(_bmpd2);   
             addChild(_bmp2);          
             var image:Bitmap = Bitmap(LoaderInfo(event.target).content);
             
            var i:int = 0;

            for(var x:int=0;x<image.width;x++)
            {
                for (var y:int=0;y<image.height;y++)
                {
                    _pixels.colors.push(image.bitmapData.getPixel(x,y));
                    _pixels.points.push(new Point(x,y));
                    _random.push(Point.polar(image.height-y,90*Math.random()));      
              }
            }    
            
            addChild(_bmp);
            
            _count = _pixels.points.length;
            for(i=0;i<_count;i++)
            {
                 _bmp.bitmapData.setPixel(100 + _pixels.points[i].x, 100 + _pixels.points[i].y, _pixels.colors[i]); 
            }


            addChild(_trace);
            this.addEventListener(Event.ENTER_FRAME,update);                                            
        }
        
        private function update(event:Event):void
        {

          
            
            if (_cC<0)
            {
            
           // _bmp.bitmapData.draw(_bmp2);
           _bmp.bitmapData.lock();
           _bmp2.bitmapData.lock();
           var cp:Point;
           var np:Point;
           var i:int;
           var tsX:Number
           var tsY:Number;
            var spl:Boolean = false;
           _count = _pixels.colors.length;
           
               for(i=0;i<_count;i++)
               {
         
                   
                   cp = Point.interpolate(_random[i], _pixels.points[i], -Math.sin(_offsetX));
                   _pixels.position[i] = cp;
                   if (_pixels.colors[i] < 0xFFFFFF) _pixels.colors[i] >>= 2;
                   
                   //if (_pixels.colors[i] == 0x000000) { _pixels.colors.splice(i,1); _pixels.points.splice(i,1); spl = true; }
                 
                   _bmp.bitmapData.setPixel(100 + cp.x, 100 + cp.y, _pixels.colors[i]); 
          
                  
               }        
               _offsetX += 0.01;
           
           
           

           _bmp.bitmapData.applyFilter(_bmpd, _rect, new Point(0, 0), _blur);
         
                _bmp.bitmapData.unlock();
           _bmp2.bitmapData.unlock();
            }
            else
            {
                  _cC--;
                  //trace(_cC);
            }

      
        }
        
        private function ioErrorHandler(event:IOErrorEvent):void
        {
            trace("Unable to load image: " + _url);
        }
        
        private function trace(val:*):void
        {
            _trace.text = String ( val );
        }
    }
}

import flash.geom.Point;

class PixelData
{
    public var colors:Vector.<uint> = new Vector.<uint>();
    public var points:Vector.<Point> = new Vector.<Point>();
    public var position:Vector.<Point> = new Vector.<Point>();
    public var speedX:Vector.<Number> = new Vector.<Number>();
    public var speedY:Vector.<Number> = new Vector.<Number>();
    public var angle:Vector.<int> = new Vector.<int>();
    public var dirY:Vector.<int> = new Vector.<int>();
    public var velocity:Vector.<Number> = new Vector.<Number>();

}

