/**
 * Copyright shihu ( http://wonderfl.net/user/shihu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zLSX
 */

// forked from kotobuki's Gainer Basic Example: Accelerometer
// forked from kotobuki's Gainer Basic Example: Analog Input
// forked from kotobuki's Gainer Basic Example: SignalScope
// A very basic example on how to use an accelerometer
// (without a smoothing filter)
// 
// ain 0: X
// ain 1: Y
// ain 2: Z
// 
// Reference
// http://funnel.cc/Software/ActionScript3

package {
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    
    import funnel.*;
    import funnel.gui.*;

    [SWF(backgroundColor="0x808080")]
    
    public class GainerTest extends Sprite {

        private var gio:Gainer;
        private var scope:SignalScope;
        private var board:Shape;
        private var yAxisPin:Pin;

        public function GainerTest() {
            gio = new Gainer();

            scope = new SignalScope(0, 5, 200, "ain 1 (y-axis)", -1, 1);
            addChild(scope);

            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            gio.gui = gui;
            gui.setPosition(IOModuleGUI.LEFT_BOTTOM);

            board = new Shape();
            board.graphics.lineStyle(5, 0xFFFFFF);
            board.graphics.moveTo(-100, 0);
            board.graphics.lineTo(100, 0);
            board.x = 100;
            board.y = 210;
            this.addChild(board);

            yAxisPin = gio.analogInput(1);
            yAxisPin.addFilter(new Scaler(0.3, 0.7, -1, 1, Scaler.LINEAR, true));

            addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop(event:Event):void {
            scope.update(gio.analogInput(1));
            board.rotation = Math.asin(yAxisPin.value) / Math.PI * 180;
        }
    }
}
