/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zL4Y
 */

/*
HANABI http://wonderfl.net/c/2PFV
forked from: HANABI（初級者がコードに注釈をつけてみた）http://wonderfl.net/c/rp2U 
を参考にさせていただきました。
*/

package {

    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.utils.*;
    import flash.geom.*;

    [SWF(width = "465",height = "465",backgroundColor = "0x000000",frameRate = "60")]


    public class Main extends Sprite {

        public var stageW:Number = stage.stageWidth;
        public var stageH:Number = stage.stageHeight;
        public var particleMax:Number;
        public var sx:Number;//花火の打ち上げ開始座標
        public var sy:Number;

        public var mtr:Matrix;
        public var canvasBMD:BitmapData;
        public var effectBMD:BitmapData;
        public var effectBM:Bitmap;

        public var rect:Rectangle;
        public var ctf:ColorTransform;
        public var blur:BlurFilter;

        public var launchTimer:Timer;


        public var particleList:Array;


        public function Main():void {

            init();

        }

        public function init():void {

            particleList=new Array();

            //キャンバス設置(下地になる。これはノーマルなまま。)
            canvasBMD = new BitmapData(stageW,stageH,false,0x0);
            addChild(new Bitmap(canvasBMD)) as Bitmap;

            //ぼかす方のビットマップを設置（scaleで４倍にすることでビットマップデータか劣化してぼやける。jpegとか引きのばすと劣化するのと同じ現象。）
            effectBMD = new BitmapData(stageW / 4,stageH / 4,false,0x0);
            effectBM = new Bitmap(effectBMD,PixelSnapping.NEVER,true);//smoothingをtrueにしないとぼやっとしない
            effectBM.scaleX = 4;
            effectBM.scaleY = 4;
            mtr = new Matrix(0.25,0,0,0.25);
            effectBM.blendMode = BlendMode.SCREEN;//下のcanvasに色をのせる為
            addChild(effectBM);

            ctf = new ColorTransform(0.9,0.8,0.3,0.9);
            rect = new Rectangle(0,0,stageW,stageH);
            blur = new BlurFilter(1,1,1);

            launchTimer = new Timer(200);
            launchTimer.addEventListener(TimerEvent.TIMER,launcher);
            launchTimer.start();

            stage.addEventListener(Event.ENTER_FRAME,enterFrameHandler);



        }


        //打ち上げて花火を描画する
        public function enterFrameHandler(e:Event):void {

            updater();

        }

        public function updater():void {

             (ctf.redMultiplier > 0.9)? ctf.redMultiplier = 0.1 : ctf.redMultiplier += 0.01;
            (ctf.greenMultiplier > 0.9)? ctf.greenMultiplier = 0.1 : ctf.greenMultiplier += 0.01;
            (ctf.blueMultiplier > 0.9)? ctf.blueMultiplier = 0.1 : ctf.blueMultiplier += 0.01;

            canvasBMD.lock();
            canvasBMD.applyFilter(canvasBMD,rect,new Point(0,0),blur);
            canvasBMD.colorTransform(rect,ctf);

            //particleMax回数繰り返す
            for (var i:Number=0; i<particleList.length; i++) {

                var p:Particle = particleList[i];

                //動かす
                p.vy += p.ay;
                p.vx*=p.gx;
                p.vy*=p.gy;
                p.x+=p.vx;
                p.y+=p.vy;

                //カウントアップ
                p.fx+=0.3;
                p.fy+=0.3;

                //キャンバスに描画する
                canvasBMD.setPixel32(p.x,p.y,p.c);

                //ステージの下か各パーチクルの絶対値＋ランダムに設定した移動値だけ進んだら配列から削除して消す
                if ((p.y>stageH)|| Math.abs(p.fy) > Math.ceil(Math.random()*(60-10))+10) {

                    particleList.splice(i,1);

                }


            }

            canvasBMD.unlock();
            effectBMD.draw(canvasBMD,mtr);


        }



        //花火を打ち上げ用意（色と開始位置を設定）
        public function launcher(e:TimerEvent):void {

            var cn:Number=Math.ceil(Math.random()*(10-1))+1;
            //タイミングをちょっとずらす
            if (cn>5) {

                //カラーの設定
                (ctf.redMultiplier > 0.9)? ctf.redMultiplier = 0.1 : ctf.redMultiplier += 0.1;
                (ctf.greenMultiplier > 0.9)? ctf.greenMultiplier = 0.1 : ctf.greenMultiplier += 0.2;
                (ctf.blueMultiplier > 0.9)? ctf.blueMultiplier = 0.1 : ctf.blueMultiplier += 0.3;

                //開始位置
                sx=Math.random()*stageW;
                sy=Math.random()*stageH/3;

                shot();

            }

        }

        //花火を打ち上げ用意（球をセット）
        public function shot():void {

            var changeNum:Number=Math.ceil(Math.random()*(300-50))+50;//パーティクルの数を変える
            var changeScale:Number=Math.ceil(Math.random()*(10)+1);//花火の大きさを変える

            particleMax=changeNum;
            //var scaler:Number=Math.random()*5;

            //particleMax回数繰り返す
            for (var i:Number=0; i<particleMax; i++) {

                var p:Particle=new Particle();

                //開始位置にセット
                p.x=sx;
                p.y=sy;

                //摩擦値を設定
                p.gx=0.99;
                p.gy=0.99;

                //加速値
                p.ay=0.05;/*加速値をなるべく小さくして摩擦をなるべく大きくするといい感じになる*/


                var radius:Number=Math.ceil(Math.random()*20);//半径を計算
                radius=(radius*changeScale)/40;
                var angle:Number=Math.random()*Math.PI*2;//角度を計算

                p.vx=radius*Math.cos(angle);
                p.vy=radius*Math.sin(angle);

                p.fx=Math.abs(p.vx);//パーティクルを消す順番の計算に使用
                p.fy=p.vy;//パーティクルを消す順番の計算に使用




                particleList.push(p);//各pは後も使うので配列に格納

            }

        }













    }

}




class Particle {

    //開始位置用
    public var x:Number=0;
    public var y:Number=0;
    //移動先用
    public var vx:Number=0;
    public var vy:Number=0;
    //加速用
    public var ax:Number=0;
    public var ay:Number=0;
    //重力用
    public var gx:Number=0;
    public var gy:Number=0;
    //
    public var fx:Number=0;
    public var fy:Number=0;
    public var ffx:Number=0;
    public var ffy:Number=0;


    public var c:uint=0xffffffff;


    public function Particle():void {
    }


}