/**
 * Copyright Hiiragi ( http://wonderfl.net/user/Hiiragi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zKzf
 */

/**
 * 回答
 * 
 * ROLL_OVER、及びROLL_OUTはバブリングを行わないため、ステージでキャッチできないようです。
 * http://livedocs.adobe.com/flash/9.0_jp/ActionScriptLangRefV3/flash/display/InteractiveObject.html#event:rollOver
 * 
 * バブリングは行いませんが、キャプチャーフェーズでは取得できるので、
 * addEventListenerの第3引数であるuseCaptureをtrueにするとキャッチできます。
 * ただし、この方法はきちんと設計を行ったうえで使わないと危険ですので、お勧めはしません。
 */
// forked from yuichiroharai's StageのROLL_OVER/OUTイベントは発動するのでしょうか？
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;

    public class StageRollOverOutTest extends Sprite {
        
        private var _circle1:Sprite;
        private var _circle2:Sprite;
        private var _textField:TextField;
        
        public function StageRollOverOutTest() {
            
            // 円を２つ作成
            _circle1 = new Sprite();
            _circle2 = new Sprite();
            _circle1.graphics.beginFill(0x996666, 1);
            _circle2.graphics.beginFill(0x666699, 1);
            _circle1.graphics.drawCircle(0, 0, 80);
            _circle2.graphics.drawCircle(0, 0, 80);            
            _circle1.graphics.endFill();
            _circle2.graphics.endFill();            
            _circle1.x = stage.stageWidth/4*3;
            _circle1.y = stage.stageHeight/4;
            _circle2.x = stage.stageWidth/4*3;
            _circle2.y = stage.stageHeight/4*3;
            _circle1.alpha = 0.5;
            _circle2.alpha = 0.5;
            addChild(_circle1);
            addChild(_circle2);
            
            // テキストフィールドを作成
            _textField = new TextField();
            _textField.x = 20;
            _textField.y = 20;
            _textField.width = stage.stageWidth/2 - 40;
            _textField.height = stage.stageHeight - 40;
            _textField.border = true;
            _textField.borderColor = 0xCCCCCC;
            _textField.textColor = 0x666666;
            _textField.multiline = true;
            _textField.selectable = false;
            addChild(_textField);
            
            // Stageのイベント登録
            stage.addEventListener(MouseEvent.ROLL_OVER, function():void { _textField.appendText("stage rollover.\n"); _textField.scrollV = _textField.numLines; }, true);
            stage.addEventListener(MouseEvent.ROLL_OUT, function():void { _textField.appendText("stage rollout.\n"); _textField.scrollV = _textField.numLines; }, true);
            stage.addEventListener(MouseEvent.MOUSE_OVER, function():void { _textField.appendText("stage mouseover.\n"); _textField.scrollV = _textField.numLines; }, true);
            stage.addEventListener(MouseEvent.MOUSE_OUT, function():void { _textField.appendText("stage mouseout.\n"); _textField.scrollV = _textField.numLines; }, true);
            
            // 円とテキストフィールドのイベント登録
            _circle1.addEventListener(MouseEvent.ROLL_OVER, function():void { _circle1.alpha = 1; });
            _circle1.addEventListener(MouseEvent.ROLL_OUT, function():void { _circle1.alpha = 0.5; });
            _circle2.addEventListener(MouseEvent.ROLL_OVER, function():void { _circle2.alpha = 1; });
            _circle2.addEventListener(MouseEvent.ROLL_OUT, function():void { _circle2.alpha = 0.5; });
            _textField.addEventListener(MouseEvent.ROLL_OVER, function():void { _textField.borderColor = 0x999999; });
            _textField.addEventListener(MouseEvent.ROLL_OUT, function():void { _textField.borderColor = 0xCCCCCC; });            
        }

    }
}