/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zKz0
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.ui.*;
	
	[SWF(width=465,height=465,backgroundColor=0x0)]
	
	/**
	 * ...
	 * @author ue
	 */
	
	public class Main extends Sprite 
	{
		public static const NUM_POINTS:int = 5;
		
		private var _points:Vector.<CustomPoint>;
		private var _canvas:BitmapData;
		private var _drawLayer:Shape;
		private var _bgLayer:Shape;
		
		public function Main():void 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			_drawLayer = new Shape();
			
			_canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xFF000000);
			addChild(new Bitmap(_canvas));
			
			_bgLayer = new Shape();
			addChild(_bgLayer);
			
			_points = new Vector.<CustomPoint>(NUM_POINTS, true);
			for (var i:int = 0; i < NUM_POINTS; i++) 
			{
				var xpos:Number = ((stage.stageWidth / (NUM_POINTS-1)) * i);
				var point:CustomPoint = new CustomPoint();
				point.x = xpos;
				point.y = Math.random() * stage.stageHeight;
				point.vy = Math.random() * 4 - 2;
				_points[i] = point;
				
				_bgLayer.graphics.lineStyle(0,0xFFFFFF, 0.3);
				_bgLayer.graphics.moveTo(xpos, 0);
				_bgLayer.graphics.lineTo(xpos, stage.stageHeight);
			}
			
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void 
		{
			var g:Graphics = _drawLayer.graphics;
			g.clear();
			g.lineStyle(0, 0xFFFFFF, 0.2);
			for (var i:int = 0; i < NUM_POINTS; i++) 
			{
				var p:CustomPoint = _points[i] as CustomPoint;
				p.y += p.vy;
				if (p.y < 0 || p.y>stage.stageHeight) p.vy *= -1;
				if (i != NUM_POINTS - 1)
				{
					var p2:CustomPoint = _points[i + 1] as CustomPoint;
					g.moveTo(p.x, p.y);
					g.lineTo(p2.x, p2.y);
				}
			}
			_canvas.draw(_drawLayer);
		}
	}
}

class CustomPoint
{
	public var x:Number ;
	public var y:Number ;
	public var vy:Number = 0;
	public function CustomPoint()
}