/**
 * Copyright mimshwright ( http://wonderfl.net/user/mimshwright )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zKb9
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	import org.as3lib.kitchensync.KitchenSync;
	import org.as3lib.kitchensync.action.*;
	import org.as3lib.kitchensync.action.group.*;
	import org.as3lib.kitchensync.action.tween.TweenFactory;
	import org.as3lib.kitchensync.core.EnterFrameCore;
	import org.as3lib.kitchensync.core.KitchenSyncEvent;
	import org.as3lib.kitchensync.easing.Cubic;
	import org.as3lib.kitchensync.utils.FrameRateView;

	/**
	* This example runs through most of the various types of 
	* groups in KitchenSync. Notice that the red square is
	* meant to move more slowly than the black circles. This
	* is to illustrate how the groups deal with children
	* that are not moving at the same rate.
	*
	* @author Mims H. Wright 
	*/
	
	[SWF(width='400',"400", backgroundColor='#FFFFFF', frameRate='50')]
	public class KSGroupDemo extends Sprite
	{
		
		private var allGroups:KSSequenceGroup;
		
		private var parallel:KSParallelGroup;
		private var sequence:KSSequenceGroup;
		private var random:KSRandomGroup;
		private var staggered:KSStaggeredGroup;
		private var simultaneousEnd:KSSimultaneousEndGroup;
		
		private var label:TextField;
		
		public function KSGroupDemo()
		{
			super();
			KitchenSync.initializeWithCore(new EnterFrameCore(this), "2.0");
			
			label = new TextField();
			label.autoSize = TextFieldAutoSize.LEFT;
			addChild(label);
			
			var frameRate:FrameRateView = new FrameRateView();
			addChild(frameRate);
			frameRate.x = 300;
			
			var sprites:Array = [];
			var tweens:Array = [];
				
			for (var i:int = 0; i < 4; i++) {
				// set up the sprites
				sprites[i] = new Sprite();
				var sprite:Sprite = Sprite(sprites[i]); 
				sprite.graphics.beginFill(0,1);
				sprite.graphics.drawCircle(0,0,10);
				sprite.x = 50;
				sprite.y = (i + 1) * 50;
				addChild(sprite);
				
				// set up the tweens for each sprite
				tweens[i] = TweenFactory.newTween(sprite, "x", 50, 300, 2000, 0, Cubic.easeInOut);
			}
			var oddSprite:Sprite = new Sprite();
			sprites[i] = oddSprite;
			oddSprite.graphics.beginFill(0x990000,1);
			oddSprite.graphics.drawRect(-10,-10,20,20);
			oddSprite.x = 50;
			oddSprite.y = (i + 1) * 50; 
			addChild(oddSprite);
			tweens[i] = TweenFactory.newTween(oddSprite, "x", 50, 300, 4000, 0, Cubic.easeInOut);
			
			
			// create groups
			sequence = new KSSequenceGroup(tweens[0], tweens[1], tweens[2], tweens[3], tweens[4]);
			random = new KSRandomGroup(tweens[0], tweens[1], tweens[2], tweens[3], tweens[4]);
			parallel = new KSParallelGroup(tweens[0], tweens[1], tweens[2], tweens[3], tweens[4]);
			staggered = new KSStaggeredGroup(500, tweens[0], tweens[1], tweens[2], tweens[3], tweens[4]);
			staggered.resetChildrenAtStart = true;
			simultaneousEnd = new KSSimultaneousEndGroup(tweens[0], tweens[1], tweens[2], tweens[3], tweens[4]);
			simultaneousEnd.resetChildrenAtStart = true;
			
			// add groups to master group.
			allGroups = new KSSequenceGroup(
				new KSFunction( setText, 0, "KSSequenceGroup"), sequence, 
				new KSFunction( setText, 0, "KSParallelGroup"), parallel, 
				new KSFunction( setText, 0, "KSStaggeredGroup (500ms)"), staggered, 
				new KSFunction( setText, 0, "KSSimultaneousEndGroup"), simultaneousEnd,
				new KSFunction( setText, 0, "KSRandomGroup"), random, 
				new KSFunction( setText, 0, "Finished")
			);
			
			allGroups.start();
		}
				
		public function setText(text:String):void {
			label.text = text;
		}
		
	}
}