/**
 * Copyright h_kamizono ( http://wonderfl.net/user/h_kamizono )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zKAo
 */

package {
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.Font;
    import flash.display.CapsStyle;
    
    
    public class FlashTest extends MovieClip {
        
        public const TOTTE:Number = 0;
        public const OMORI:Number = 1;
        public const OMORI2:Number = 2;
        
        public const acc:Number = 50;
        
           
        public var pt:Array = new Array();
        public var hammerAlpha:Number = 0;
            
        public var preMouse:Point;
        public var curMouse:Point;
            
        public var kazu:Number = 100;
        public var loc:Array = new Array();
        public var isPressed:Boolean = false;
        public function FlashTest() {
            // write as3 code here..
            pt[TOTTE] = new PhysicalPoint();
            pt[OMORI] = new PhysicalPoint();
            //
            pt[OMORI2] = new PhysicalPoint(); 
            
            for (var i:Number = 0; i < kazu; ++i) {
                loc.push(new Array());
                loc[loc.length - 1][0] = new Point();
                loc[loc.length - 1][1] = new Point();
                //
                //loc[loc.length - 1][2] = 0x000000;
                loc[loc.length - 1][2] = new Point();
                loc[loc.length - 1][3] = 0x000000;
            }
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN,
                                   function(ev:MouseEvent) :void {isPressed = true;});
            stage.addEventListener(MouseEvent.MOUSE_UP,
                                   function(ev:MouseEvent) :void {isPressed = false;});
            curMouse = new Point(mouseX, mouseY);
            
            var timer:Timer = new Timer(33);
            timer.addEventListener(TimerEvent.TIMER, loop);                       
            timer.start();
        }
        
        
        public function loop(event:TimerEvent) :void {
            preMouse = curMouse;
            curMouse = new Point(mouseX, mouseY);
            
            
            
            if (preMouse.x != curMouse.x || 
                preMouse.y != curMouse.y) {
                
                pt[TOTTE].x += (curMouse.x - pt[TOTTE].x)/4;
                pt[TOTTE].y += (curMouse.y - pt[TOTTE].y)/4;
                
                pt[OMORI].setKasokudo((pt[TOTTE].x - pt[OMORI].x)*10,
                                      (pt[TOTTE].y - pt[OMORI].y)*10);
                //
                pt[OMORI2].setKasokudo((pt[OMORI].x - pt[OMORI2].x)*2,
                                      (pt[OMORI].y - pt[OMORI2].y)*2); 
            } else {
                pt[OMORI].setKasokudo((pt[TOTTE].x - pt[OMORI].x)*2,
                                      (pt[TOTTE].y - pt[OMORI].y)*2);
                pt[TOTTE].setKasokudo((-pt[TOTTE].x + pt[OMORI].x)*10,
                                      (-pt[TOTTE].y + pt[OMORI].y)*10);
                //
                
            }
            
            for (var i:Number = 0; i < pt.length; ++i) {
                if (pt[i].x < 0) {
                    pt[i].setKasokudo(acc, 0);
                }
                if (pt[i].y < 0) {
                    pt[i].setKasokudo(0, acc);
                }
                if (pt[i].x > stage.stageWidth) {
                    pt[i].setKasokudo(-acc, 0);
                }
                if (pt[i].y > stage.stageHeight) {
                    pt[i].setKasokudo(0, -acc);
                }
            }
            var angle:Number = Math.atan2(pt[OMORI].y - pt[TOTTE].y,
                                          pt[OMORI].x - pt[TOTTE].x)/Math.PI*180;
            var dist:Number = Point.distance(pt[OMORI], pt[TOTTE]);
            dist = Math.min(dist/200, 1)*0.5 + 0.5;
            var col:uint = Functions.hsbToRgb(angle, 1, dist);
            
            for (var j:Number = 1; j < loc.length; ++j) {
                for (var k:Number = 0; k < loc[j].length; ++k) {
                    loc[j - 1][k] = loc[j][k];
                }
            }
            
            loc[loc.length - 1][0] = new Point(pt[TOTTE].x, pt[TOTTE].y);
            loc[loc.length - 1][1] = new Point(pt[OMORI].x, pt[OMORI].y);
            //loc[loc.length - 1][2] = col;
            loc[loc.length - 1][2] = new Point(pt[OMORI2].x, pt[OMORI2].y);
            loc[loc.length - 1][3] = col;
            
            if (isPressed) {
                hammerAlpha = Math.min(1, hammerAlpha+0.1);
            } else {
                hammerAlpha = Math.max(0, hammerAlpha-0.1);
            }
            this.graphics.clear();
            this.graphics.lineStyle(3, 0xCCCCCC, hammerAlpha);
            this.graphics.beginFill(0x88888888, hammerAlpha);
            this.graphics.drawCircle(pt[OMORI].x, pt[OMORI].y, 30);
            this.graphics.endFill();
            this.graphics.beginFill(0x88888888, hammerAlpha);
            this.graphics.drawCircle(pt[TOTTE].x, pt[TOTTE].y, 8);
            this.graphics.endFill();
            //
            this.graphics.beginFill(0x88888888, hammerAlpha);
            this.graphics.drawCircle(pt[OMORI2].x, pt[OMORI2].y, 8);
            this.graphics.endFill();
            
            for (var m:Number = 0; m < loc.length; ++m) {
                drawShikaku(this, loc[m][0], loc[m][1], loc[m][3], m/loc.length);
                //drawShikaku(this, loc[m][1], loc[m][2], 0xFFFFFF, 1.0);
            }


        }

        public function drawShikaku(s:Sprite, pt0:Point, pt1:Point,
                             col:uint, al:Number) :void {
            var dist:Number = Point.distance(pt0, pt1);
            var angle:Number = Math.atan2(pt1.y-pt0.y, pt1.x - pt0.x);
            var a:Number = 20/dist;
            var ptA:Point = new Point(
                                      pt0.x + dist*0.3*Math.cos(angle + a),
                                      pt0.y + dist*0.3*Math.sin(angle + a));
            var ptB:Point = new Point(
                                      pt1.x + dist*0.3*Math.cos(angle + a + Math.PI),
                                      pt1.y + dist*0.3*Math.sin(angle + a + Math.PI));
           var par:Number = Math.min(dist, 500)/500;
           s.graphics.lineStyle(0, 0, 0);
           s.graphics.moveTo(pt0.x, pt0.y);
           s.graphics.beginFill(col, par*al);
           s.graphics.lineTo(ptA.x, ptA.y);
           s.graphics.lineTo(pt1.x, pt1.y);
           s.graphics.lineTo(ptB.x, ptB.y);
           s.graphics.endFill();
        }
    }
}
import flash.display.AVM1Movie;


import flash.geom.Point;
import flash.events.TimerEvent;
import flash.utils.Timer;

import flash.display.Sprite;
import flash.display.MovieClip;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.ui.Mouse;

class Functions {
    public static function hsbToRgb(h:Number,
                                    s:Number,
                                    b:Number) :uint {
        while (h < 0) {
            h+=360;
        }
        while (h >= 360) {
            h -= 360;
        }
        var h2:Number = Math.floor(h/60);
        var f:Number = h/60 - h2;
        var parFull:Number = 255;
        var parEmp:Number = 0;
        var parZoka:Number = 255*f;
        var parGensho:Number = 255*(1-f);
        var red:Number = 0;
        var green:Number = 0;
        var blue:Number = 0;
        
        switch (h2) {
          case 0:
            red = parFull; green = parZoka; blue = parEmp;
            break;
          case 1:
            red = parGensho; green = parFull; blue = parEmp;
            break;
          case 2:
            red = parEmp; green = parFull; blue = parZoka;
            break;
          case 3:
            red = parEmp; green = parGensho; blue = parFull;
            break;
          case 4:
            red = parZoka; green = parEmp; blue = parFull;
            break;
          case 5:
            red = parFull; green = parEmp; blue = parGensho;
            break;
        }
        var max:Number = Math.max(Math.max(red, green), blue);
        red = max - (max - red)*s;
        green = max - (max - green)*s;
        blue = max - (max - blue)*s;
        red *= b; green *= b; blue *= b;
        var ret:uint = int(red) << 16 | int(green) << 8 | int(blue);
        return ret; 
    }
    
    //public static function rgbToHsb(rgb:uint) :Array {
        
    //}
    
}


class PhysicalPoint extends Point {
    public var vx:Number, vy:Number;
    public var ax:Number, ay:Number;
    public var b:Number;
    public var sakkiTime:Number;
    public var timer:Timer;
    
    public var preX:Number, preY:Number;
    
    public var kb:Number;
    public var angle:Number;
    public var preAngle:Number;
    public var kakusokudo:Number;
    public var kakukasokudo:Number;
    
    public var limitter:Number = 0.3;
    
    function PhysicalPoint(xx: Number = 0, yy:Number = 0, an:Number = 0) {
        x = xx; y = yy;
        preX = xx; preY = yy;
        b = 0.9;
        vx = 0; vy = 0;
        ax = 0; ay = 0;
        
        angle = an;
        preAngle = an;
        kb = 0.9;
        kakusokudo = 0;
        kakukasokudo = 0;
        
        sakkiTime = new Date().getTime();
        timer = new Timer(33);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start();
        
    }
    
    public function loop(event:TimerEvent) :void {
        var nowTime:Number = new Date().getTime();
        var t:Number = (nowTime - sakkiTime)/1000;
        
        if (t > limitter) t = limitter;
        
        preX = x;
        preY = y;
        
        x += vx*t + 0.5*ax*t*t;
        y += vy*t + 0.5*ay*t*t;
        
        vx += ax*t; vy += ay*t;
        vx *= b;    vy *= b;
        ax = 0;     ay = 0;
        preAngle = angle;
        angle += kakusokudo * t + 0.5*kakukasokudo*t*t;
        kakusokudo += kakusokudo*t;
        
        kakusokudo *= kb;
        kakukasokudo = 0;
        sakkiTime = nowTime;
    }
    
    public function setKasokudo(aax:Number = 0, aay:Number = 0) :void {
        ax += aax;
        ay += aay;
    }
    
    public function setKasokudoByPolar(r:Number=0, dire:Number = 0) :void {
        ax += r*Math.cos(dire);
        ay += r*Math.sin(dire);
    }
    
    public function setKakuKasokudo(aan:Number = 0) :void {
        kakukasokudo += aan;
    }
    
    public function setKakuKasokudo2(dire:Number, val:Number) :void {
        var aan:Number = val * Math.sin(dire - angle);
        setKakuKasokudo(aan);
    }

}
