/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zJzR
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix3D;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Utils3D;
	import flash.geom.Vector3D;

	[SWF(width="480", height="480", backgroundColor="0xffffff", frameRate="15")];
	public class Practice61 extends Sprite {
		private var viewport:Sprite;
		private var worldMt:Matrix3D;
		private var viewMt:Matrix3D;
		private var proj:PerspectiveProjection;
		
		private var margin:int = 40;
		private var mx:int = 60, my:int = 60, dxy:Number = 10;
		private var px:Array;
		private var py:Array;
		private var pz:Array;
		private var vert:Vector.<Number>;
		private var uvt:Vector.<Number>;
		private var nn:Number = 0.0;
		
		public function Practice61() {
			viewport = new Sprite();
			viewport.x = margin, viewport.y = margin;
			addChild(viewport);
			worldMt = new Matrix3D();
			viewMt = new Matrix3D();
			viewMt.appendTranslation(-50, 280, 300);
			proj = new PerspectiveProjection();
			proj.fieldOfView = 60;
			px = new Array();
			py = new Array();
			for (var i:int = 0; i < mx; i++) {
				px[i] = new Array();
				py[i] = new Array();
				for (var j:int = 0; j < my; j++) {
					px[i][j] = i * dxy;
					py[i][j] = j * dxy;
				}
			}
			pz = new Array();
			for (i = 0; i < mx; i++) {
				pz[i] = new Array();
				for (j = 0; j < my; j++) {
					var xx:Number = i;
					var yy:Number = j;
					pz[i][j] = 10*Math.cos(xx/20.0)+10*Math.sin(yy/10.0);
				}
			}
			vert = new Vector.<Number>();
			uvt = new Vector.<Number>();
			for (i = 1; i < mx; i++) {
				for (j = 1; j < my; j++) {
					vert.push(px[i - 1][j - 1], py[i - 1][j - 1],pz[i - 1][j - 1]);
					vert.push(px[i][j - 1], py[i][j - 1], pz[i][j - 1]);
					vert.push(px[i - 1][j], py[i - 1][j], pz[i - 1][j]);
					vert.push(px[i - 1][j], py[i - 1][j], pz[i - 1][j]);
					vert.push(px[i][j - 1], py[i][j - 1], pz[i][j - 1]);
					vert.push(px[i][j], py[i][j], pz[i][j]);
				}
			}
			worldMt.appendRotation(100,Vector3D.X_AXIS);
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void {
			render();
			updateWaveH();
		}
		
		private function render():void {
			var m:Matrix3D = new Matrix3D();
			m.append(worldMt);
			m.append(viewMt);
			m.append(proj.toMatrix3D());
			var pp:Vector.<Number> = new Vector.<Number>();
			Utils3D.projectVectors(m, vert, pp, uvt);
			viewport.graphics.clear();
			viewport.graphics.lineStyle(1, 0x8888ff);
			viewport.graphics.beginFill(0xaaaaff,1.0);
			viewport.graphics.drawTriangles(pp);
			viewport.graphics.endFill();
		}
		
		private function updateWaveH():void {
			for (var i:int = 0; i < mx; i++) {
				pz[i] = new Array();
				for (var j:int = 0; j < my; j++) {
					var xx:Number = i;
					var yy:Number = j;					
					pz[i][j] = 5 * Math.cos(xx / 30.0 + nn);
					pz[i][j] += 5 * Math.sin(yy / 20.0 + 2 * nn);
					pz[i][j] += 10 * Math.cos(xx / 3.0 + 3 * nn) + 10 * Math.sin(yy / 3.0 + 5 * nn);
					pz[i][j] += 20 * Math.sin((xx+yy) / 120.0 + 2*nn);
				}
			}
			nn += 0.05;
			var ii:int = 2;
			for (i = 1; i < mx; i++) {
				for (j = 1; j < my; j++) {
					vert[ii] = pz[i - 1][j - 1];
					ii = ii + 3;
					vert[ii] = pz[i][j - 1];
					ii = ii + 3;
					vert[ii] = pz[i - 1][j];
					ii = ii + 3;
					vert[ii] = pz[i - 1][j];
					ii = ii + 3;
					vert[ii] = pz[i][j - 1];
					ii = ii + 3;
					vert[ii] = pz[i][j];
					ii = ii + 3;
				}
			}
		}
	}
}