/**
 * Copyright Matt_Wakeling ( http://wonderfl.net/user/Matt_Wakeling )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zIeX
 */

package
{
    // Import External Classes
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageQuality;
    
    // Reconfigure Stage Properties
    [SWF(width='465',height='465',backgroundColor='#000000',frameRate='60')]
    
    /**
     * Name           : Main
     * Coded By       : Matt Wakeling
     * Date           : 08th May 2012
     * Description    : Main Class for the Application.
     *                  ActionScript 3 Mandlebrot - based on code from Rosetta Code.
     *
     * @author Matt Wakeling
     */
    public class Main extends Sprite
    {
        private var $Resolution:int = 1;
        
        // Main Constructor
        public function Main()
        {
            // Constructor Code
            super();
            InitialiseMain();
        }
        
        // InitialiseMain Method
        private function InitialiseMain():void
        {
            if (stage)
                this.InitialiseStage();
            else
                addEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage, false, 0, true);
        }
        
        // InitialiseStage Method
        private function InitialiseStage(evtInitialiseStage:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.BEST;
            
            // Black Screen for Wonderfl Capture
            this.graphics.beginFill(0x000000, 1);
            this.graphics.drawRect(stage.x, stage.y, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
            
            initMandelbrot();
        
            //addChild(new Stats());
        }
        
        // initMandelbrot Method
        private function initMandelbrot():void
        {
            var scrMandelbrot:Mandelbrot = new Mandelbrot(stage.stageWidth, stage.stageHeight, $Resolution);
            scrMandelbrot.cacheAsBitmap = true;
            scrMandelbrot.scaleX = 1 / $Resolution;
            scrMandelbrot.scaleY = 1 / $Resolution;
            
            addChild(scrMandelbrot);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import frocessing.color.ColorHSV;

class Mandelbrot extends Sprite
{
    private var $Width:int = 0;
    private var $Height:int = 0;
    private var $Scale:int = 10;
    
    private var $FrameCounter:int = 0;
    
    private var $BitmapData:BitmapData;
    private var $Bitmap:Bitmap;
    
    private var $StepX:Number = 0;
    private var $StepY:Number = 0;
    
    
    // Mandelbrot Constructor
    public function Mandelbrot($StageWidth:int, $StageHeight:int, $StageResolution:int)
    {
        
        $Width = $StageWidth * $StageResolution;
        $Height = $StageHeight * $StageResolution;
        
        $BitmapData = new BitmapData($Width, $Height, false, 0xFFFFFF);
        $Bitmap = new Bitmap($BitmapData);
        
        addChild($Bitmap);
    
        $StepX = 3 / ($Width-1);
        $StepY = 2.0 / ($Height-1);
       
        addEventListener(Event.ENTER_FRAME, FrameEvent);
    }
    
    // FrameEvent Method
    private function FrameEvent($Event:Event):void
    {
        $BitmapData.lock();
    
        var ci:Number = $FrameCounter * $StepY - 1.0;
            
            for (var j:int = 0; j < $Width; j++ ) {
                var $ColorIncrementer:Number = 0;
                var zr:Number = 0.0;
                var zi:Number = 0.0;
                var cr:Number = j * $StepX - 2.0;
                while ($ColorIncrementer <= 255 && (zr*zr + zi*zi) <= 4) {
                    var temp:Number = zr*zr - zi*zi + cr;
                    zi = 2*zr*zi + ci;
                    zr = temp;
                    $ColorIncrementer ++;
                }
                $BitmapData.setPixel(j, $FrameCounter, $ColorIncrementer * 0x111111);
                
            }
        
        $BitmapData.unlock();
        
        if ($FrameCounter++ >= $Height)
        {
            removeEventListener(Event.ENTER_FRAME, FrameEvent);
        }
    
    }
    
}

