/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zI52
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	
	/**
	 * ...
	 * @author okoi
	 */
	public class Main extends Sprite 
	{
		private	var	_canvas:BitmapData;
		private var _noise:BitmapData;
		private var _noiseOffset:Array;
		
		private	var _sphere:Sprite;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			
			_sphere = new Sprite();
			_sphere.graphics.beginFill( 0x0 );
			_sphere.graphics.drawCircle( 0, 0, 15 );
			_sphere.graphics.endFill();
			
			
			_canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xFFFFFFFF );
			addChild( new Bitmap( _canvas )	);
			
			CreateNoise();
			
			
			addEventListener( Event.ENTER_FRAME, Update );
		}
		
		private function Update(e:Event):void 
		{
			_noiseOffset[0].x += 3;
			
			_noise.perlinNoise(
				30,
				40,
				1,
				0,
				true,
				true,
				BitmapDataChannel.RED | BitmapDataChannel.GREEN | BitmapDataChannel.BLUE | BitmapDataChannel.ALPHA,
				false,
				_noiseOffset
			);
			
			//
			_canvas.lock();
			_canvas.fillRect( _canvas.rect, 0xFF000000 );
		
			//_canvas.draw( _noise );
			
			var xsize:int = int(stage.stageWidth / 40);
			var ysize:int = int(stage.stageHeight / 40);
			
			for ( var y:int = 0; y < ysize; y++ )
			{
				for ( var x:int = 0; x < xsize; x++ )
				{
					var	color:uint = _noise.getPixel32( x * 40 + 20, y * 40 + 20 );
					
					
					var colorTrans:ColorTransform = new ColorTransform();
					colorTrans.redOffset = (color >> 16) & 0xFF;
					colorTrans.greenOffset = (color >> 8) & 0xFF;
					colorTrans.blueOffset = (color) & 0xFF;
					
					var scale:Number = ((color >> 24) & 0xFF) / 0xFF * 2; 
					
					_canvas.draw( _sphere, new Matrix(scale, 0, 0, scale, x * 40 + 30, y * 40 + 30), colorTrans );
					
				}
			}
			
			_canvas.unlock();
		}
		
		private	function CreateNoise() : void
		{
			_noise = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0 );
			_noiseOffset = [ new Point() ];
		}
		
	}
	
}