/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zHah
 */

package
{
	import com.adobe.utils.AGALMiniAssembler;
	import flash.display.*;
	import flash.display3D.Context3D;
	import flash.display3D.Context3DProgramType;
	import flash.display3D.Context3DTriangleFace;
	import flash.display3D.Program3D;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix3D;
	import flash.geom.Point;
	import flash.geom.Utils3D;
	import flash.geom.Vector3D;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.Endian;
	import flash.utils.getTimer;
	import mx.utils.Base64Decoder;
	import net.hires.debug.Stats;
	import flash.utils.ByteArray;
	/**
	 * ...
	 * @author lizhi http://game-develop.net/
	 */
	[SWF(frameRate=60)]
	
	public class Test3D7 extends Sprite
	{
		private var root3d:Obj3D = new Obj3D;
		private var obj:Obj3D = new Obj3D;
		private var light:Vector3D = new Vector3D(0, 0, -1,.3);
		private var lightByte:ByteArray = new ByteArray;
		private var lightHelp:Matrix3D = new Matrix3D;
		private var camera:Camera = new Camera;
		private var pps:Vector.<Polygon> = new Vector.<Polygon>;
		private var debug:TextField = new TextField;
		
		//stage3d
		private var c3d:Context3D; 
		
		private var bmd:BitmapData = new BitmapData(400,400,false,0);
		private var image:Bitmap = new Bitmap(bmd);
		private var time:int = 0;
		public function Test3D7()
		{
			stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, stage3Ds_context3dCreate);
			stage.stage3Ds[0].requestContext3D();
			//addChild(image);
		}
		
		private function stage3Ds_context3dCreate(e:Event):void 
		{
			addChild(new Stats);
			c3d = stage.stage3Ds[0].context3D;
			c3d.configureBackBuffer(400, 400, 16);
			c3d.setCulling(Context3DTriangleFace.BACK);
			//c3d.enableErrorChecking = true;
			
			program = c3d.createProgram();
			var vagal:AGALMiniAssembler = new AGALMiniAssembler(false);
			vagal.assemble(Context3DProgramType.VERTEX, 
					"m44 op,va0,vc0\n"+
					"mov v0, va1\n" +
					"mov vt0,va2\n"+
					"m33 vt0.xyz, va2, vc4\n"+
					"nrm vt0.xyz, vt0.xyz\n"+
					"mov v1,vt0"
					);
			var fagal:AGALMiniAssembler = new AGALMiniAssembler(false);
			fagal.assemble(Context3DProgramType.FRAGMENT, 
					"dp3 ft0.x,fc0.xyz,v1.xyz\n" +
					"add ft0.x,ft0.x,fc0.w\n"+
					"sat ft0.x,ft0.x\n" +
					"mul oc,v0,ft0.xxx"
					);
			program.upload(vagal.agalcode, fagal.agalcode);
			c3d.setProgram(program);
			S3D.c3d = c3d;
			//init(MDAE.dae);
			//return;
			var b64:Base64Decoder = new Base64Decoder;
			b64.decode("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");
			var bytes:ByteArray = b64.flush();
			var loader:Loader = new Loader;
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loader_complete);
			loader.loadBytes(bytes);
			//	alpha = .3;
			
		}
		
		private function initPlane():void {
			plane = new Obj3D;
			var w:int = 100;
			var ins:Vector.<int> = new Vector.<int>;
			var bmd:BitmapData = new BitmapData(w, w);
			bmd.perlinNoise(32, 32, 3, 10000 * Math.random(), true, true);
			for (var y:int = 0; y < w;y++ ) {
				for (var x:int = 0; x < w;x++ ) {
					plane.vin.push((x / w - .5)*100, (y / w - .5)*100, ((0xff&bmd.getPixel(x,y))/0xff-.5)*10);
					if (x!=w-1&&y!=w-1) {
						plane.polygons.push(Obj3D.createPolygon(plane, Vector.<int>([y * w + x, y * w + x + 1, (y + 1) * w + x]), new Vector3D));
						plane.polygons.push(Obj3D.createPolygon(plane, Vector.<int>([y * w + x + 1, (y + 1) * w + 1 + x, (y + 1) * w + x]), new Vector3D));
					}
				}
			}
			//plane.scale.setTo(10, 10, 10);
			//plane.position.z = 2;
			
			plane.vectorlight = true;
			Obj3D.computeNorm(plane);
			obj.add(plane);
			root3d.initStage3D(true,.5,.5,.1);
		}
		
		private function getHeight(x:Number,y:Number):Number {
			x /= 100;
			x += .5;
			x = x * 100;
			var ix:int = x;
			var fx:Number = x % 1;
			y /= 100;
			y += .5;
			y = y * 100;
			var iy:int = y;
			var fy:Number = y % 1;
			var i0:Number = ix + iy * 100;
			var i1:Number = ix +1+ iy * 100;
			var i2:Number = ix + (iy+1) * 100;
			var i3:Number = ix +1 + (iy + 1) * 100;
			var z0:Number = plane.vin[3 * i0 + 2];
			var z1:Number = plane.vin[3 * i1 + 2];
			var z2:Number = plane.vin[3 * i2 + 2];
			var z3:Number = plane.vin[3 * i3 + 2];
			var z01:Number = z0 + (z1 - z0) * fx;
			var z23:Number = z2 + (z3 - z2) * fx;
			var z0123:Number = z01 + (z23 - z01) * fy;
			return z0123;
		}
		
		private function initDae(daexml:XML):void {
			var dae:DAE = new DAE;
			
			dae.parser(daexml);
			var daeobj:Obj3D = dae.obj3d;
			obj.add(daeobj);
			
			/*daeobj = Obj3D.createCube(1);
			daeobj.vectorlight = true;
			Obj3D.computeNorm(daeobj);*/
			
			daeobj.scale.setTo(1, 1, 1);
			daeobj.scale.scaleBy(.1);
			daeobj.rotation.y = Math.PI;
			daeobj.position.z = getHeight(0, 0);
			daeobj.name = "dae";
			/*for each(var skinobj:Obj3D in dae.skins) {
				var maxJoint:int = 30;
				var maxJointPerVector:int = 0;
				var counters:Array = [];
				var j:int = 0;
				//for (var i:int = 0, len:int = skinobj.skin.vcount.length; i < len; i++ ) {//i顶点索引
				for each(var p:Polygon in skinobj.polygons) {
					for (var i:int = 0; i < p.indices.length;i+=3 ) {
						var jointIndexs:Array = [];
						for (var len2:int = skinobj.skin.vcount[i]*2 + j; j < len2; j+=2 ) {
							var jointIndex:int = skinobj.skin.v[j];//骨骼索引
							jointIndexs.push(jointIndex);
						}
						var iobj:Object = null;
						for each(var counter:Object in counters) {
							var flag:Boolean = true;
							var clength:int = int(counter.length);
							for each(jointIndex in jointIndexs) {
								if(counter[jointIndex]==null){
									clength++;
								}
								if (clength > maxJoint) {
									flag = false;
									break;
								}
							}
							if (flag) {
								iobj = counter;
								break;
							}
						}
						if (iobj==null) {
							iobj = {};
							counters.push(iobj);
						}
						for each(jointIndex in jointIndexs) {
							if (iobj[jointIndex]==null) {
								iobj[jointIndex] = {};
								iobj.length = int(iobj.length) + 1;
							}
						}
					}
				}
				
			}*/
			//return;
			
			root3d.initStage3D(true,0,0,0);
			
			var c:int = 10;
			for (var x:int = 0; x < c;x++ ) {
				for (var y:int = 0; y < c;y++ ) {
					var clone:Obj3D = daeobj.clone2();
					clone.name = "clone";
					clone.position.x = (x-c/2);
					clone.position.y = (y - c / 4);
					clone.position.z = getHeight(clone.position.x, clone.position.y);
					/*clone.position.x = 3 * (Math.random()-.5);
					clone.position.y = 3 * (Math.random()-.5);
					clone.position.z = 3 * (Math.random()-.5);*/
					
					obj.add(clone);
				}
			}
		}
		
		private function init(daexml:XML):void
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			light.normalize();
			lightByte.endian = Endian.LITTLE_ENDIAN;
			lightByte.writeFloat(light.x);
			lightByte.writeFloat(light.y);
			lightByte.writeFloat(light.z);
			lightByte.writeFloat(light.w);
			
			
		//	obj.rotation.x = Math.PI/2;
			new DragController(stage, obj);
			
			root3d.add(obj);
			camera.position.z = -5;
			initPlane();
			initDae(daexml);
			
			addEventListener(Event.ENTER_FRAME, enterFrame);
		}
		
		private function loader_complete(e:Event):void
		{
			//init(Dae2.dae);
			//return;
			init(((e.currentTarget as LoaderInfo).content as Object).dae as XML);
		}
		
		private function enterFrame(e:Event):void
		{
			c3d.clear();
			var c:int = 1;
			while (c-->0) {
				if(camera.matrixChanged){
					camera.matrix.recompose(camera.comps);
					camera.invert.copyFrom(camera.matrix);
					camera.invert.invert();
				}
				
				//pps.length = 0;
				for each (var obj3d:Obj3D in root3d.children)
				{
					do3d(obj3d,false);
				}
				camera.matrixChanged = false;
				//pps.sort(psort);
			}
			time++;
			if (time > 600 && image.parent) image.parent.removeChild(image);
			if(image.parent)c3d.drawToBitmapData(bmd);
			c3d.present();
		}
		
		private function psort(p1:Polygon, p2:Polygon):Number
		{
			return p2.vz - p1.vz;
		}
		
		private function doAnimation(anms:Vector.<Animation>, time:Number,maxTime:Number):void { 
			var rd:Vector.<Number> = new Vector.<Number>;
			var joints:Vector.<Obj3D> = new Vector.<Obj3D>;
			for each(var anm:Animation in anms) {
				for each(var cannel:Channel in anm.channels) {
					var obj3d:Obj3D = cannel.target;
					joints.push(obj3d);
					for (var i:int = 0, len:int = cannel.input.length; i < len;i++ ) {
						if (cannel.input[i]>time) {
							break;
						}
					}
					var j:int = i - 1;
					if (j < 0) {
						j = len - 1;
						var v:Number = (time-cannel.input[j]+maxTime) / (cannel.input[i] - cannel.input[j]+maxTime);
					}else if (i>=len) {
						i = 0;
						v = (time-cannel.input[j]) / (cannel.input[i]+maxTime - cannel.input[j]);
					}else {
						v = (time-cannel.input[j]) / (cannel.input[i] - cannel.input[j]);
					}
					obj3d.matrix.copyRawDataTo(rd);
					if (cannel.index == -1) {
						var mj:Matrix3D = cannel.output[j];
						var mi:Matrix3D = cannel.output[i];
						mj.interpolateTo(mi, v);
						mj.copyRawDataTo(rd);
					}else{
						rd[cannel.index] = cannel.output[j] + (cannel.output[i] - cannel.output[j]) * v;
					}
					obj3d.matrix.copyRawDataFrom(rd); 
				}
			}
			for each(obj3d in joints) {
				var comps:Vector.<Vector3D> = obj3d.matrix.decompose();
				obj3d.position.copyFrom(comps[0]);
				obj3d.rotation.copyFrom(comps[1]);
				obj3d.scale.copyFrom(comps[2]);
				obj3d.matrixChanged = true;
			}
		}
		
		private var vin:Vector.<Number>;
		private var vout:Vector.<Number>;
		private var program:Program3D;
		private var plane:Obj3D;
		private function doSkin(obj3d:Obj3D):void {
			var skin:Skin = obj3d.skin;
			var matrixs:Vector.<Matrix3D> = new Vector.<Matrix3D>;
			var skeleton:Matrix3D = new Matrix3D;
			skeleton.copyFrom(obj3d.skeleton.parent.worldMatrix);
			skeleton.invert();
			for (var i:int = 0, len:int = skin.joints.length; i < len;i++) {
				var joint:Obj3D = skin.joints[i];
				var matrix:Matrix3D = new Matrix3D;
				matrix.copyFrom(joint.worldMatrix);
				matrix.append(skeleton);
				matrix.prepend(skin.invBindMatrix[i]);
				matrixs.push(matrix);
			}
			if(vin==null){
				vin = new Vector.<Number>(obj3d.vin.length);
				obj3d.bind_shape_matrix.transformVectors(obj3d.vin, vin);
				vout = new Vector.<Number>(vin.length);
			}
			vout.length = 0;
			vout.length = vin.length;
			
			var j:int = 0;
			var len2:int;
			var vcount:Vector.<int> = skin.vcount;
			var v:Vector.<int> = skin.v;
			var weights:Vector.<Number> = skin.weights;
			var pos:Vector3D = new Vector3D;
			for (i = 0, len = vcount.length; i < len; i++ ) {
				var ix:int = i * 3;
				var iy:int = ix + 1;
				var iz:int = iy + 1;
				pos.x = vin[ix];
				pos.y = vin[iy];
				pos.z = vin[iz];
				for (len2 = vcount[i]*2 + j; j < len2; j+=2 ) {
					var m:Matrix3D = matrixs[v[j]];
					var w:Number = weights[v[j + 1]];
					var pos2:Vector3D = m.transformVector(pos);
					vout[ix] += pos2.x * w;
					vout[iy] += pos2.y * w;
					vout[iz] += pos2.z * w;
				}
			}
			//obj3d.viewMatrix.transformVectors(vout, obj3d.vout);
			obj3d.vertexBuff.uploadFromVector(vout, 0, vout.length / 3);
		}
		
		private final function do3d(obj3d:Obj3D,parentMatrixChanged:Boolean):void
		{
			if (obj3d.anms) {
				var time:Number = (getTimer()/1000) % obj3d.maxTime;
				doAnimation(obj3d.anms, time,obj3d.maxTime);
			}
			if (obj3d.matrixChanged) { 
				obj3d.matrix.recompose(obj3d.comps);
				parentMatrixChanged = true;
				obj3d.matrixChanged = false;
			}
			if (parentMatrixChanged) {
				obj3d.worldMatrix.copyFrom(obj3d.matrix);
				obj3d.worldMatrix.append(obj3d.parent.worldMatrix);
				if (obj3d.vertexBuff) { 
					obj3d.worldMatrix.copyRawDataTo(obj3d.byteVector, 0, true);
					obj3d.bytes.position = 64;
					for each(var v:Number in obj3d.byteVector) {
						obj3d.bytes.writeFloat(v);
					}
				}
			}
			if(obj3d.vertexBuff&&(parentMatrixChanged||camera.matrixChanged)){
				obj3d.viewMatrix.copyFrom(obj3d.worldMatrix);
				obj3d.viewMatrix.append(camera.invert);
				obj3d.perspectiveProjectionMatirx.copyFrom(obj3d.viewMatrix);
				obj3d.perspectiveProjectionMatirx.append(camera.perspectiveProjection);
				obj3d.perspectiveProjectionMatirx.copyRawDataTo(obj3d.byteVector, 0, true);
				obj3d.bytes.position = 0;
				for each(v in obj3d.byteVector) {
					obj3d.bytes.writeFloat(v);
				}
			}
			if(obj3d.skin){
				doSkin(obj3d);
			}else {
				
			}
			
			if (obj3d.vertexBuff) { 
				c3d.setVertexBufferAt(0, obj3d.vertexBuff, 0, "float3");
				c3d.setVertexBufferAt(1, obj3d.colorBuff, 0, "float3");
				c3d.setVertexBufferAt(2, obj3d.normBuff, 0, "float3");
				//c3d.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, obj3d.perspectiveProjectionMatirx, true);
				//c3d.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 4, obj3d.worldMatrix, true);
				c3d.setProgramConstantsFromByteArray(Context3DProgramType.VERTEX, 0,8,obj3d.bytes,0);
				//c3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, Vector.<Number>([light.x, light.y, light.z, light.w]));
				c3d.setProgramConstantsFromByteArray(Context3DProgramType.FRAGMENT, 0,1,lightByte,0);
				c3d.drawTriangles(obj3d.indexBuff);
			}
			
			for each (var ch3d:Obj3D in obj3d.children)
			{
				do3d(ch3d,parentMatrixChanged);
			}
		}
	}
}
import flash.display.*;
import flash.display3D.IndexBuffer3D;
import flash.display3D.VertexBuffer3D;
import flash.events.MouseEvent;
import flash.geom.*;
import flash.utils.ByteArray;
import flash.utils.Dictionary;
import flash.display3D.Context3D;
class S3D {
	public static var graphics:Graphics;
	public static var camera:Camera;
	public static var c3d:Context3D
}

class Obj3D
{
	public var type:String = "NODE";
	public var name:String;
	public var parent:Obj3D;
	public var children:Vector.<Obj3D> = new Vector.<Obj3D>;
	public var matrixChanged:Boolean = true;
	public var matrix:Matrix3D = new Matrix3D;
	public var comps:Vector.<Vector3D> = matrix.decompose();
	public var position:Vector3D = comps[0];
	public var rotation:Vector3D = comps[1];
	public var scale:Vector3D = comps[2];
	public var worldMatrix:Matrix3D = new Matrix3D;
	public var viewMatrix:Matrix3D = new Matrix3D;
	public var perspectiveProjectionMatirx:Matrix3D = new Matrix3D;
	public var polygons:Vector.<Polygon> = new Vector.<Polygon>;
	
	public var vin:Vector.<Number> = new Vector.<Number>;
	public var vout:Vector.<Number> = new Vector.<Number>;
	public var uvt:Vector.<Number> = new Vector.<Number>;
	public var projectedVerts:Vector.<Number> = new Vector.<Number>;
	
	public var faceLight:Boolean = false; //是否计算facelight
	public var vectorlight:Boolean = false; //是否计算顶点光
	public var normVin:Vector.<Number>;
	public var normVout:Vector.<Number>;
	public var normUv:Vector.<Number>;
	
	public var material:Material;
	public var culling:String = TriangleCulling.NEGATIVE;
	public var anms:Vector.<Animation>;
	public var maxTime:Number;
	public var skin:Skin;
	public var skeleton:Obj3D;
	public var bind_shape_matrix:Matrix3D;
	
	//stage3d
	public var vertexBuff:VertexBuffer3D;
	public var normBuff:VertexBuffer3D;
	public var colors:Vector.<Number>;
	public var colorBuff:VertexBuffer3D;
	public var indexBuff:IndexBuffer3D;
	public var bytes:ByteArray;
	public var byteVector:Vector.<Number>;
	public function add(obj3d:Obj3D):Obj3D
	{
		children.push(obj3d);
		obj3d.parent = this;
		/*for each (var p:Polygon in obj3d.polygons)
		{
			//Test3D6.tcount += p.indices.length / 3;
		}*/
		return obj3d;
	}
	
	public function clone(is2:Boolean=false):Obj3D {
		var obj3d:Obj3D = new Obj3D;
		obj3d.type = type;
		obj3d.position.copyFrom(position);
		obj3d.rotation.copyFrom(rotation);
		obj3d.scale.copyFrom(scale);
		obj3d.polygons = polygons;
		obj3d.vin = vin;
		obj3d.vout=vout ;
		obj3d.uvt= uvt;
		obj3d.projectedVerts=projectedVerts ;
		obj3d.faceLight=faceLight ;
		obj3d.vectorlight=vectorlight ;
		obj3d.normVin=normVin ;
		obj3d.normVout=normVout ;
		obj3d.normUv=normUv;
		obj3d.culling=culling;
		obj3d.anms=anms;
		obj3d.maxTime=maxTime;
		obj3d.skin=skin;
		obj3d.skeleton=skeleton;
		if(bind_shape_matrix)obj3d.bind_shape_matrix=bind_shape_matrix.clone();
		obj3d.colors=colors;
		
		for each(var cobj3d:Obj3D in children) {
			if(!is2)
			obj3d.add(cobj3d.clone(is2));
			else 
			obj3d.add(cobj3d.clone2());
		}
		return obj3d;
	}
	public function clone2():Obj3D {
		var obj3d:Obj3D = clone(true);
		obj3d.anms = null;
		obj3d.skin = null;
		obj3d.vertexBuff= vertexBuff;
		obj3d.normBuff= normBuff;
		obj3d.colorBuff= colorBuff;
		obj3d.indexBuff = indexBuff;
		if (obj3d.vertexBuff) {
			obj3d.initBytes();
		}
		return obj3d;
	}
	
	public static function computeNorm(obj3d:Obj3D):void
	{
		if (obj3d.vectorlight)
		{
			if (obj3d.normVin == null || obj3d.normVin.length == 0) obj3d.normVin = new Vector.<Number>(obj3d.vin.length);
		}
		for each (var p:Polygon in obj3d.polygons)
		{
			p.norm.setTo(0, 0, 0);
			for (var i:int = 0, len:int = p.indices.length; i < len; i += 3)
			{
				var i0:int = p.indices[i] * 3;
				var i1:int = p.indices[i + 1] * 3;
				var i2:int = p.indices[i + 2] * 3;
				var vin:Vector.<Number> = obj3d.vin;
				var v1:Vector3D = new Vector3D(vin[i0] - vin[i1], vin[i0 + 1] - vin[i1 + 1], vin[i0 + 2] - vin[i1 + 2]);
				var v2:Vector3D = new Vector3D(vin[i2] - vin[i1], vin[i2 + 1] - vin[i1 + 1], vin[i2 + 2] - vin[i1 + 2]);
				p.norm = p.norm.add(v1.crossProduct(v2));
			}
			p.norm.normalize();
			if (obj3d.normVin)
			{
				for (i = 0, len = p.indices.length; i < len; i++)
				{
					i0 = p.indices[i] * 3;
					vin = obj3d.normVin;
					vin[i0] += p.norm.x;
					vin[i0 + 1] += p.norm.y;
					vin[i0 + 2] += p.norm.z;
				}
			}
		}
		if (obj3d.vectorlight)
		{
			vin = obj3d.normVin;
			for (i = 0, len = vin.length; i < len; i += 3)
			{
				var norm:Vector3D = new Vector3D(vin[i], vin[i + 1], vin[i + 2]);
				norm.normalize();
				vin[i] = norm.x;
				vin[i + 1] = norm.y;
				vin[i + 2] = norm.z;
			}
		}
	}
	
	public static function createPolygon(obj3d:Obj3D, indices:Vector.<int>, norm:Vector3D):Polygon
	{
		var polygon:Polygon = new Polygon;
		polygon.obj3d = obj3d;
		polygon.indices = indices;
		polygon.norm = norm;
		return polygon;
	}
	
	public static function createCube(r:Number):Obj3D
	{
		var color:uint = 0;
		var obj3d:Obj3D = new Obj3D;
		obj3d.vin = Vector.<Number>([-r, -r, r, r, -r, r, -r, r, r, r, r, r, -r, -r, -r, r, -r, -r, -r, r, -r, r, r, -r, -r, -r, r, -r, r, r, -r, -r, -r, -r, r, -r, r, -r, r, r, r, r, r, -r, -r, r, r, -r, -r, -r, r, r, -r, r, -r, -r, -r, r, -r, -r, -r, r, r, r, r, r, -r, r, -r, r, r, -r]);
		obj3d.uvt = Vector.<Number>([0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0]);
		obj3d.projectedVerts = new Vector.<Number>(obj3d.vin.length * 2 / 3);
		obj3d.vout = new Vector.<Number>(obj3d.vin.length);
		obj3d.polygons.push(createPolygon(obj3d, Vector.<int>([0, 2, 1, 1, 2, 3]), new Vector3D(0, 0, 1)));
		obj3d.polygons.push(createPolygon(obj3d, Vector.<int>([4, 5, 6, 5, 7, 6]), new Vector3D(0, 0, -1)));
		obj3d.polygons.push(createPolygon(obj3d, Vector.<int>([8, 10, 9, 9, 10, 11]), new Vector3D(-1, 0, 0)));
		obj3d.polygons.push(createPolygon(obj3d, Vector.<int>([12, 13, 14, 13, 15, 14]), new Vector3D(1, 0, 0)));
		obj3d.polygons.push(createPolygon(obj3d, Vector.<int>([16, 17, 18, 17, 19, 18]), new Vector3D(0, -1, 0)));
		obj3d.polygons.push(createPolygon(obj3d, Vector.<int>([20, 22, 21, 21, 22, 23]), new Vector3D(0, 1, 0)));
		return obj3d;
	}
	
	public function initStage3D(isDepth:Boolean,r:Number,g:Number,b:Number):void {
		if (vertexBuff) vertexBuff.dispose();
		if(vin&&vin.length>0){
			vertexBuff = S3D.c3d.createVertexBuffer(vin.length / 3, 3);
			vertexBuff.uploadFromVector(vin, 0, vin.length / 3);
			if (colors == null || colors.length == 0) {
				colors = new Vector.<Number>(vin.length);
				for (var i:int = 0; i < colors.length;i+=3 ) {
					colors[i] = r;
					colors[i+1] = g;
					colors[i+2] = b;
				}
			}
		}
		if (colorBuff) colorBuff.dispose();
		if(colors&&colors.length>0){
			colorBuff = S3D.c3d.createVertexBuffer(vin.length / 3, 3);
			colorBuff.uploadFromVector(colors, 0, vin.length / 3);
		}
		if (normBuff) normBuff.dispose();
		if(normVin&&normVin.length>0){
			normBuff = S3D.c3d.createVertexBuffer(vin.length / 3, 3);
			normBuff.uploadFromVector(normVin, 0, vin.length / 3);
		}
		if (indexBuff) indexBuff.dispose();
		
		var indices:Vector.<uint> = new Vector.<uint>;
		for each(var p:Polygon in polygons) {
			for each(i in p.indices) {
				indices.push(i);
			}
		}
		if (indices.length) {
			indexBuff = S3D.c3d.createIndexBuffer(indices.length);
			indexBuff.uploadFromVector(indices,0,indices.length);
		}
		initBytes();
		if (isDepth) {
			for each(var obj:Obj3D in children) {
				obj.initStage3D(isDepth,r,g,b);
			}
		}
	}
	
	private function initBytes():void {
		bytes = new ByteArray;
		bytes.endian = flash.utils.Endian.LITTLE_ENDIAN;
		bytes.length = 4 * 16 * 2;
		byteVector = new Vector.<Number>(16);
	}
	
	public static function createSphere(r:Number, nh:int = 4, nv:int = 7, vnorm:Boolean = false):Obj3D
	{
		var obj3d:Obj3D = new Obj3D;
		obj3d.vin.push(0, -r, 0);
		obj3d.uvt.push(.5, 0, 0);
		
		for (var i:int = 1; i <= nv; i++)
		{
			var az:Number = (i / (nv + 1) - .5) * Math.PI;
			var uvv:Number = i / (nv + 1);
			for (var j:int = 0; j < nh; j++)
			{
				obj3d.uvt.push(j / nh, uvv, 0);
				var ay:Number = j / nh * 2 * Math.PI;
				var x:Number = r * Math.cos(az);
				var vy:Number = r * Math.sin(az);
				var vx:Number = x * Math.cos(ay);
				var vz:Number = x * Math.sin(ay);
				
				obj3d.vin.push(vx, vy, vz);
				var a:int = (i - 1) * nh + j + 1;
				var b:int = j == (nh - 1) ? a - nh + 1 : a + 1;
				var c:int = i == nv ? nv * nh + 1 : a + nh;
				var d:int = j == (nh - 1) ? c - nh + 1 : c + 1;
				if (i != nv)
				{
					obj3d.polygons.push(createPolygon(obj3d, Vector.<int>([a, b, c, b, d, c]), new Vector3D));
				}
				else
				{
					obj3d.polygons.push(createPolygon(obj3d, Vector.<int>([a, b, c]), new Vector3D));
				}
			}
			;
		}
		obj3d.vin.push(0, r, 0);
		obj3d.uvt.push(.5, 1, 0);
		for (j = 0; j < nh; j++)
		{
			obj3d.polygons.push(createPolygon(obj3d, Vector.<int>([0, j == (nh - 1) ? 1 : j + 2, j + 1]), new Vector3D));
		}
		obj3d.projectedVerts = new Vector.<Number>(obj3d.vin.length * 2 / 3);
		obj3d.vout = new Vector.<Number>(obj3d.vin.length);
		if (vnorm)
		{
			obj3d.normVin = new Vector.<Number>(obj3d.vin.length);
			obj3d.normVout = new Vector.<Number>(obj3d.vin.length);
			obj3d.normUv = new Vector.<Number>(obj3d.vin.length * 2 / 3);
		}
		computeNorm(obj3d);
		return obj3d;
	}
}

class DAE
{
	private var ns:Namespace;
	private var dae:XML;
	private var children:Object = { };
	private var joints:Object = { };
	public var obj3d:Obj3D;
	public var anms:Vector.<Animation>;
	public var maxTime:Number = 0;
	public var skins:Vector.<Obj3D> = new Vector.<Obj3D>;
	private var controllerAndSkeletonName:Array = [];
	public function parser(dae:XML):void
	{
		this.dae = dae;
		obj3d = new Obj3D;
		ns = dae.namespace();
		var xroot:XML = dae.ns::scene.ns::instance_visual_scene[0];
		buildNode(xroot, obj3d);
		buildController();
		anms = buildAnimation();
		obj3d.anms = anms;
		obj3d.maxTime = maxTime;
	}
	
	private function buildController():void {
		for each(var arr:Array in controllerAndSkeletonName) {
			var controller:Obj3D = arr[0];
			skins.push(controller);
			controller.skeleton = arr[0];
			var dskin:Skin = new Skin;
			controller.skin = dskin;
			var xml:XML = arr[1];
			var sname:String = String(xml.ns::skeleton[0]).substr(1);
			//controller.skeleton = children[sname];
			var icontroller:XML = getControllerById(String(xml.@url).substr(1));
			var skin:XML = icontroller.ns::skin[0];
			var bind_shape_matrix:Matrix3D = getMatrixFromXML(skin.ns::bind_shape_matrix[0]);
			controller.bind_shape_matrix = bind_shape_matrix;
			var vertex_weights:XML = skin.ns::vertex_weights[0];
			var jointId:String = String(vertex_weights.ns::input.(@semantic=="JOINT").@source).substr(1);
			var joint:Array = getArrFromXML(skin.ns::source.(@id == jointId).ns::Name_array[0], String);
			var jointObjs:Array = [];
			for each(var jstr:String in joint) {
				jointObjs.push(joints[jstr]);
			}
			var weightId:String = String(vertex_weights.ns::input.(@semantic=="WEIGHT").@source).substr(1);
			var weight:Array = getArrFromXML(skin.ns::source.(@id==weightId).ns::float_array[0],Number);
			var vcount:Array = getArrFromXML(vertex_weights.ns::vcount[0], int);
			var v:Array = getArrFromXML(vertex_weights.ns::v[0], int);
			
			var invBindMatrixId:String = String(skin.ns::joints.ns::input.(@semantic == "INV_BIND_MATRIX").@source).substr(1);
			var invBindMatrix:Array = getMatrixsFromXML(skin.ns::source.(@id == invBindMatrixId).ns::float_array[0]);
			
			dskin.invBindMatrix = Vector.<Matrix3D>(invBindMatrix);
			dskin.joints = Vector.<Obj3D>(jointObjs);
			dskin.v = Vector.<int>(v);
			dskin.vcount = Vector.<int>(vcount);
			dskin.weights = Vector.<Number>(weight);
		}
	}
	
	private function buildAnimation():Vector.<Animation> {
		var areg:RegExp=/(.+)\/(.+)\((\d+)\)\((\d+)\)///.+\/.+\(.+\)\(.+\)/;
		var areg2:RegExp=/(.+)\/(.+)///.+\/.+\(.+\)\(.+\)/;
		var xl:XMLList = dae.ns::library_animations.ns::animation;
		var anms:Vector.<Animation> = new Vector.<Animation>;
		for each(var xa:XML in xl) {
			var channels:XMLList = xa.ns::channel;
			var anm:Animation = new Animation;
			anms.push(anm);
			for each(var channel:XML in channels) {
				var sourceId:String = String(channel.@source).substr(1);
				var sampler:XML = xa.ns::sampler.(@id == sourceId)[0];
				var inputId:String = String(sampler.ns::input.(@semantic == "INPUT").@source).substr(1);
				var outputId:String = String(sampler.ns::input.(@semantic == "OUTPUT").@source).substr(1);
				//var interpolationId:String = String(sampler.ns::input.(@semantic == "INTERPOLATION").@source).substr(1);
				var input:Array = String(xa.ns::source.(@id == inputId).ns::float_array[0]).split(/\s+/);
				var output:Array = String(xa.ns::source.(@id == outputId).ns::float_array[0]).split(/\s+/);
				//var interpolation:Array = String(xa.ns::source.(@id == interpolationId).ns::float_array[0]).split(/\s+/);
				changeArrType(input, Number);
				changeArrType(output, Number);
				for each(var tt:Number in input) {
					if (maxTime < tt) maxTime = tt;
				}
				//changeArrType(interpolation, Number);
				//var output:Array
				//var interpolation:Array // = XML (@7cbcf89 element <input semantic="INTERPOLATION
				var target:String = channel.@target;
				var aexe:Object = areg.exec(target);
				if (aexe) {
					var targetId:String = aexe[1];
					var targetObj:Obj3D = children[targetId];
					var targetKey:String = aexe[2];
					if(targetKey=="transform"){
						var x:int = int(aexe[3]);
						var y:int = int(aexe[4]);
						var can:Channel = new Channel;
						can.input = input;
						can.output = output;
						can.target = targetObj;
						can.index = y + x * 4;
						anm.channels.push(can);
					}
				}else {
					aexe = areg2.exec(target);
					if(aexe){
						targetId = aexe[1];
						targetKey = aexe[2];
						if(targetKey=="transform"){
							targetObj = children[targetId];
							can = new Channel;
							can.input = input;
							can.output = getMatrixsFromArr(output);
							can.target = targetObj;
							can.index = -1;
							anm.channels.push(can);
						}
					}else {
						trace("error");
					}
				}
			}
		}
		return anms;
	}
	
	private function buildNode(xnode:XML, node:Obj3D):void
	{
		if (xnode.@url != undefined)
		{
			var url:String = xnode.@url;
			xnode = getSceneById(url.substr(1));
		}
		var xcontroller:XMLList = xnode.ns::instance_controller;
		for each (var controller:XML in xcontroller)
		{
			var icontroller:XML = getControllerById(String(controller.@url).substr(1));
			var skins:XMLList = icontroller.ns::skin;
			for each(var skin:XML in skins) {
				var obj:Obj3D = new Obj3D;
				controllerAndSkeletonName.push([obj, controller]);
				var geometry:XML = getGeometryById(String(skin.@source).substr(1));
				var mesh:XML = geometry.ns::mesh[0];
				var xv:XML = mesh.ns::vertices[0];
				var vlib:XML = getVerticesById(String(xv.@id), mesh);
				var vlibarray:Array = String(vlib.ns::float_array[0]).split(/\s+/);
				var len:int = vlibarray.length;
				
				var vs:Vector.<Number> = new Vector.<Number>(len);
				var colors:Vector.<Number> = new Vector.<Number>(len);
				obj.colors = colors;
				for (var i:int = 0; i < len; i++)
				{
					vs[i] = Number(vlibarray[i]);
				}
				
				var polylists:XMLList = mesh.ns::polylist;
				for each (var polylist:XML in polylists)
				{
					var cr:Number = Math.random();
					var cg:Number = Math.random();
					var cb:Number = Math.random();
					var mp:Vector.<Polygon> = new Vector.<Polygon>;
					var v:XML = polylist.ns::vcount[0];
					var varray:Array = String(v).split(/\s+/);
					var p:XML = polylist.ns::p[0];
					var parray:Array = String(p).split(/\s+/);
					len = varray.length;
					var pi:int = 0;
					for (i = 0; i < len; i++)
					{
						var inc:Vector.<int> = new Vector.<int>;
						var c:int = int(varray[i]);
						for (var j:int = 0; j < c; j++)
						{
							var i0:int = int(parray[pi * 3]);
							inc.push(i0);
							colors[i0 * 3] = cr;
							colors[i0 * 3+1] = cg;
							colors[i0 * 3+2] = cb;
							pi++;
						}
						var po:Polygon = Obj3D.createPolygon(obj, p2t(inc), new Vector3D);
						obj.polygons.push(po);
						mp.push(po);
					}
					var material:DAEMaterial = getMaterial(polylist.@material, controller);
					//var fm:FastGouraudColorMaterial = new FastGouraudColorMaterial(null, 0xffffff*Math.random()/*material.ambient*/);
					//fm.obj = obj;
					//fm.foreachCustom(mp); 
				}
				var triangles:XMLList = mesh.ns::triangles;
				for each (var triangle:XML in triangles)
				{
					
					cr = Math.random();
					cg = Math.random();
					cb = Math.random();
					mp = new Vector.<Polygon>;
					p = triangle.ns::p[0];
					parray = getArrFromXML(p,Number);
					len = parray.length;
					for (i = 0; i < len; i+=9)
					{
						inc = new Vector.<int>;
						inc.push(Number(parray[i]));
						inc.push(Number(parray[i+6]));
						inc.push(Number(parray[i + 3]));
						
						colors[Number(parray[i])*3] = cr;
						colors[Number(parray[i])*3+1] = cg;
						colors[Number(parray[i]) * 3 + 2] = cb;
						
						colors[Number(parray[i+3])*3] = cr;
						colors[Number(parray[i+3])*3+1] = cg;
						colors[Number(parray[i+3])*3+2] = cb;
						
						colors[Number(parray[i+6])*3] = cr;
						colors[Number(parray[i+6])*3+1] = cg;
						colors[Number(parray[i+6])*3+2] = cb;
						
						po = Obj3D.createPolygon(obj, inc, new Vector3D);
						obj.polygons.push(po);
						mp.push(po);
					}
					material = getMaterial(triangle.@material, controller);
					//fm = new FastGouraudColorMaterial(null, 0xffffff*Math.random()/*material.ambient*/);
					//fm.obj = obj;
					//fm.foreachCustom(mp);
				}
				
				obj.vin = vs;
				obj.vout = new Vector.<Number>(obj.vin.length);
				obj.uvt = new Vector.<Number>(obj.vin.length);
				obj.projectedVerts = new Vector.<Number>(obj.vin.length * 2 / 3);
				obj.normVin = new Vector.<Number>(obj.vin.length);
				obj.normVout = new Vector.<Number>(obj.vin.length);
				obj.normUv = new Vector.<Number>(obj.vin.length*2/3);
				obj.vectorlight = true;
				Obj3D.computeNorm(obj);
				//FastGouraudColorMaterial.randomNormUv(obj);
				//obj.material =new FastGouraudColorMaterial(obj, 0xffffff * Math.random());
				node.add(obj);
			}
		}
		var list:XMLList = xnode.ns::node;
		for each (var xcnode:XML in list)
		{
			if (xcnode.@type == "NODE") {
				var cnode:Obj3D = new Obj3D
			}else if (xcnode.@type == "JOINT") {
				cnode = new Obj3D//Obj3D.createCube(.1);
				cnode.type = "JOINT";
				//cnode.faceLight = true;
				joints[xcnode.@sid] = cnode;
				//cnode.material = new JointFastFlatColorMaterial(cnode,0xffffff*Math.random());
			}
			children[String(xcnode.@id)] = cnode;
			cnode.type = xcnode.@type;
			node.add(cnode);
			var xmatrix:XMLList = xcnode.ns::matrix;
			if (xmatrix.length()>0) {
				
				var matrix:Matrix3D = getMatrixFromXML(xmatrix[0])
				var comps:Vector.<Vector3D> = matrix.decompose();
				cnode.position.copyFrom(comps[0]);
				cnode.rotation.copyFrom(comps[1]);
				cnode.scale.copyFrom(comps[2]);
				cnode.matrix.copyFrom(matrix);
			}
			buildNode(xcnode, cnode);
		}
	}
	
	private function getMatrixFromXML(xml:XML):Matrix3D {
		var amatrix:Array = getArrFromXML(xml, Number);
		var vmatrix:Vector.<Number> = new Vector.<Number>(16);
		for (var i:int = 0; i < 16;i++ ) {
			var x:int = i % 4;
			var y:int = i / 4;
			vmatrix[x*4+y] = amatrix[i];
		}
		return new Matrix3D(vmatrix);
	}
	
	private function getMatrixsFromXML(xml:XML):Array {
		var amatrix:Array = getArrFromXML(xml, Number);
		return getMatrixsFromArr(amatrix);
	}
	
	private function getMatrixsFromArr(amatrix:Array):Array {
		var arr:Array = [];
		for (var i:int = 0, len:int = amatrix.length; i < len;i+=16 ) {
			var vmatrix:Vector.<Number> = new Vector.<Number>(16);
			for (var j:int = 0; j < 16;j++ ) {
				var x:int = j % 4;
				var y:int = j / 4;
				vmatrix[x*4+y] = amatrix[i+j];
			}
			arr.push(new Matrix3D(vmatrix));
		}
		return arr;
	}
	
	private function p2t(inc:Vector.<int>):Vector.<int>
	{
		var inc2:Vector.<int> = new Vector.<int>;
		for (var i:int = 1, len:int = inc.length - 1; i < len; i++)
		{
			inc2.push(inc[0], inc[i + 1], inc[i]);
		}
		return inc2;
	}
	
	private function getArrFromXML(xml:XML, type:Class):Array {
		var arr:Array = String(xml).split(/\s+/);
		changeArrType(arr, type);
		return arr;
	}
	
	private function changeArrType(arr:Array, type:Class):void {
		for (var i:int = 0, len:int = arr.length; i < len;i++ ) {
			arr[i] = type(arr[i]);
		}
	}
	
	private function getSceneById(id:String):XML
	{
		return dae.ns::library_visual_scenes.ns::visual_scene.(@id == id)[0];
	}
	
	public function getControllerById(id:String):XML {
		return dae.ns::library_controllers.ns::controller.(@id == id)[0];
	}
	
	private function getGeometryById(id:String):XML
	{
		return dae.ns::library_geometries.ns::geometry.(@id == id)[0];
	}
	
	private function getVerticesById(id:String, mesh:XML):XML
	{
		var list:XMLList = mesh.ns::source.(@id == id);
		if (list.length())
		{
			return list[0];
		}
		var vxml:XMLList = mesh.ns::vertices.(@id == id);
		if (vxml.length() == 0)
			return null;
		var source:String = vxml.ns::input.@source;
		return getVerticesById(source.substr(1), mesh);
	}
	
	private function getMaterial(id:String,xml:XML):DAEMaterial {
		var target:String = String(xml.ns::bind_material.ns::technique_common.ns::instance_material.(@symbol == id).@target).substr(1);
		var material:String = String(dae.ns::library_materials.ns::material.(@id == target).ns::instance_effect.@url).substr(1);
		var effectProfile:XML = dae.ns::library_effects.ns::effect.(@id == material).ns::profile_COMMON[0];
		var daem:DAEMaterial = new DAEMaterial;
		var arr:Array = String(effectProfile.ns::technique.ns::phong.ns::ambient.ns::color).split(/\s+/);;
		daem.ambient=((Number(arr[0])*0xff)<<16)|((Number(arr[1])*0xff)<<8)|((Number(arr[2])*0xff));
		return daem;
	}
}

class Animation {
	public var channels:Vector.<Channel> = new Vector.<Channel>;
}

class Channel {
	public var target:Obj3D;
	public var index:int;
	public var input:Array;
	public var output:Array;
}

class Skin {
	public var joints:Vector.<Obj3D> = new Vector.<Obj3D>;
	public var weights:Vector.<Number> = new Vector.<Number>;
	public var vcount:Vector.<int> = new Vector.<int>;
	public var v:Vector.<int> = new Vector.<int>;
	public var invBindMatrix:Vector.<Matrix3D> = new Vector.<Matrix3D>;
}

class DAEMaterial {
	public var file:String;
	public var ambient:int;
	public var diffuse:Number;
}

class Polygon
{
	public var obj3d:Obj3D;
	public var indices:Vector.<int> = new Vector.<int>;
	public var lines:Vector.<Point> = new Vector.<Point>; //直线
	public var clines:Vector.<Vector3D> = new Vector.<Vector3D>; //曲线
	public var vz:Number;
	public var lightWeight:Number = 1;
	public var norm:Vector3D;
	public var materialBase:MaterialBase;
}

class Camera extends Obj3D
{
	public var fl:Number;
	private var width:Number;
	private var height:Number;
	private var near:Number;
	private var far:Number;
	public var invert:Matrix3D = new Matrix3D;
	public var perspectiveProjection:Matrix3D=new Matrix3D;
	//public var perspectiveProjection:PerspectiveMatrix3D = new PerspectiveMatrix3D;
	public function Camera(fl:Number = 0, width:Number = 0, height:Number = 0, near:Number = 0, far:Number = 0)
	{
		this.far = far;
		this.near = near;
		this.height = height;
		this.width = width;
		this.fl = fl;
		//var pp:PerspectiveProjection = new PerspectiveProjection;
		//pp.focalLength = fl;
		//perspectiveProjection = pp.toMatrix3D();
		//this.fl = perspectiveProjection.rawData[0];
		perspectiveFieldOfViewLH(Math.PI / 4, 1, .1, 400);
		
	}
	public function perspectiveFieldOfViewLH(fieldOfViewY:Number, 
												 aspectRatio:Number, 
												 zNear:Number, 
												 zFar:Number):void {
			var yScale:Number = -1.0/Math.tan(fieldOfViewY/2.0);
			var xScale:Number = -yScale / aspectRatio; 
			perspectiveProjection.copyRawDataFrom(Vector.<Number>([
				xScale, 0.0, 0.0, 0.0,
				0.0, yScale, 0.0, 0.0,
				0.0, 0.0, zFar/(zFar-zNear), 1.0,
				0.0, 0.0, (zNear*zFar)/(zNear-zFar), 0.0
			]));
		}
}

class DragController
{
	public var speed:Number = 1;
	
	private var stage:Stage;
	private var target:Obj3D;
	
	private var sx:Number;
	private var sy:Number;
	private var sm:Matrix3D;
	private var nx:Number;
	private var ny:Number;
	private var v3d:Vector3D = new Vector3D();
	private var axis:Vector3D = new Vector3D();
	private var m:Matrix3D = new Matrix3D;
	
	public function DragController(stage:Stage, target:Obj3D, autoStart:Boolean = true)
	{
		this.stage = stage;
		this.target = target;
		if (autoStart)
			start();
	}
	
	public function start():void
	{
		stage.addEventListener(MouseEvent.MOUSE_DOWN, onMD);
	}
	
	private function onMD(e:MouseEvent):void
	{
		sx = stage.mouseX;
		sy = stage.mouseY;
		sm = target.matrix.clone();
		stage.addEventListener(MouseEvent.MOUSE_MOVE, onMM);
		stage.addEventListener(MouseEvent.MOUSE_UP, onMU);
	}
	
	private function onMU(e:MouseEvent):void
	{
		stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMM);
		stage.removeEventListener(MouseEvent.MOUSE_UP, onMU);
	}
	
	private function onMM(e:MouseEvent):void
	{
		nx = stage.mouseX;
		ny = stage.mouseY;
		var mx:Number = nx - sx;
		var my:Number = ny - sy;
		var d:Number = Math.sqrt(mx * mx + my * my); // Point.distance(cp, np);
		var a:Number = -d * speed;
		v3d.x = mx;
		v3d.y = my;
		v3d.z = 0;
		axis = Vector3D.Z_AXIS.crossProduct(v3d);
		axis.normalize();
		m.copyFrom(sm);
		m.appendRotation(a, axis);
		var comps:Vector.<Vector3D> = m.decompose();
		target.rotation.copyFrom(comps[1]);
		target.matrixChanged = true;
	}
	
	public function stop():void
	{
		stage.removeEventListener(MouseEvent.MOUSE_DOWN, onMD);
		stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMM);
		stage.removeEventListener(MouseEvent.MOUSE_UP, onMU);
	}
}

class Material
{
	public var obj:Obj3D;
	private var c:Class;
	
	public function Material(obj:Obj3D, c:Class)
	{
		this.c = c;
		this.obj = obj;
		foreach();
	}
	
	public function foreach():void
	{
		if(obj)
		foreachCustom(obj.polygons);
	}
	
	public function foreachCustom(polygons:Vector.<Polygon>):void {
		for each (var p:Polygon in polygons)
		{
			var mb:MaterialBase = new c as MaterialBase;
			p.materialBase = mb;
			mb.p = p;
			mb.m = this;
			func(mb, p);
		}
	}
	
	public function func(mb:MaterialBase, p:Polygon):void
	{
	
	}
}

class MaterialBase
{
	public var p:Polygon;
	public var m:Material;
	
	public function doMaterial(gd:Vector.<IGraphicsData>):void
	{
	
	}
}