/**
 * Copyright jerryrom ( http://wonderfl.net/user/jerryrom )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zHaM
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	
	public class Main extends Sprite 
	{
		private var bmpdata:BitmapData;
		private var matrix:Matrix;
		private var circle:Sprite;
		
		[SWF(width="465", height="465", framerate="30")]
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			bmpdata = new BitmapData(465, 465, false, 0xFFFFFF);
			addChild(new Bitmap(bmpdata, "auto", true));
			
			circle = new Sprite();
			circle.graphics.beginFill(0xaa2222);
			circle.graphics.drawCircle(0, 0, 10);
			circle.graphics.endFill();

			matrix = new Matrix();
			matrix.identity();
			matrix.translate(465/2, y);
			
			addEventListener(Event.ENTER_FRAME, enterframe);
		}
		
		private function enterframe(e:Event):void 
		{
			var x:Number = (Math.random() - 0.5)*4;
			var y:Number = Math.random()*5;
			matrix.translate(x, y);
			bmpdata.draw(circle, matrix);
			bmpdata.draw(circle, matrix);
			if (matrix.ty >= 465) {
				matrix.identity();
				matrix.translate(Math.random() * 465, 0);
			}
		}
	}
}