/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zHWz
 */

// forked from siouxcitizen's Away3D Gold Practice02 Plane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice01 Plane 1枚表示
//Away3D 4.0 Gold で複数WireframePlaneを表示してみました
//
//以下サイトを参考にしました
//http://away3d.com/livedocs/away3d/4.0/away3d/primitives/WireframePlane.html
//
package {
    import away3d.containers.View3D;
    import away3d.debug.AwayStats;
    import away3d.primitives.WireframePrimitiveBase ;
    import away3d.primitives.WireframePlane;

    import flash.events.Event;
    import flash.geom.Vector3D;

    import flash.display.Bitmap;
    import flash.display.BitmapData;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    public class WireframePlaneSample extends View3D {

        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private var _wrPlane01 : WireframePlane;
        private var _wrPlane02 : WireframePlane;
        private var _wrPlane03 : WireframePlane;
        private var _wrPlane04 : WireframePlane;
        private var _wrPlane05 : WireframePlane;

        private var _capture : BitmapData = new BitmapData(465, 465, false, 0x000000);

        public function WireframePlaneSample() {

           // wonderfl capture
           Wonderfl.disable_capture();
           //addChild(new Bitmap(_capture)) ;

            antiAlias = 0;
            backgroundColor = 0x222222;

            _wrPlane01 = new WireframePlane(300, 300, 2, 2, 0xff0000, 9);
            _wrPlane01.y += 250;
            scene.addChild(_wrPlane01);

            _wrPlane02 = new WireframePlane(300, 300, 4, 4, 0x00ff00, 3);
            _wrPlane02.x += 250;
            scene.addChild(_wrPlane02);

            _wrPlane03 = new WireframePlane(300, 300, 4, 4, 0x0000ff, 3);
            _wrPlane03.x -= 250;
            scene.addChild(_wrPlane03);

            _wrPlane04 = new WireframePlane(300, 300, 2, 2, 0xffff00, 9);
            _wrPlane04.y -= 250;
            scene.addChild(_wrPlane04);

            _wrPlane05 = new WireframePlane(300, 300, 8, 8, 0xff00ff, 1);
            _wrPlane05.y = 0;
            scene.addChild(_wrPlane05);

            camera.y = 0;
            camera.z = -700;
            addEventListener(Event.ENTER_FRAME, update);
                   
            addChild(new AwayStats());
        }

        private function update(event : Event) : void {

            _wrPlane01.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _wrPlane01.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _wrPlane02.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _wrPlane02.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _wrPlane03.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _wrPlane03.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _wrPlane04.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _wrPlane04.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _wrPlane05.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _wrPlane05.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            camera.lookAt(ZERO);
            render();
            //renderer.queueSnapshot(_capture);
        }
    }
}