/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zHT1
 */

/* ---------------------------------------------------------------
 * 作業的運ゲーを兼ねたテストです。
 * 平然とランキングに載ってしまうような輩は、
 * Flashさんに対する愛と信心が足りないと思われます。
 * ---------------------------------------------------------------
 * [操作方法]
 * 画面をクリック : どつく
 * 「Send Score」ボタンを押す : DQN自慢する
 * ---------------------------------------------------------------
 * Scorer         : ScoreFormのテスト
 * ScoreIndicator : そこらのRPGにありがちなダメージ表示を行うクラス
 * TextBuilder    : TextFieldの面倒な設定を軽減するはずのBuilder
 * ---------------------------------------------------------------
 */
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import net.wonderfl.utils.FontLoader;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    public class Main extends Sprite {
        //["Aqua","Azuki","Cinecaption","Mona","Sazanami","YSHandy","VLGothic","IPAGP","IPAM","UmeUgo","UmePms","Bebas"]
        public static const FONT:String = "Mona";
        public static const EMBED:Boolean = true;
        
        private var _flashBody:Sprite;
        private var _scorer:Scorer;
        
        private var _tween:ITween;
        private var _duration:int;
        
        public function Main() {
            var fontLoader:FontLoader = new FontLoader();
            fontLoader.addEventListener(Event.COMPLETE, initialize);
            fontLoader.load(Main.FONT);
        }
        
        private function initialize(event:Event = null):void {
            if (event) { event.target.removeEventListener(Event.COMPLETE, initialize); }
            
            _flashBody = new Sprite();
            _flashBody.graphics.beginFill(0x000000);
            _flashBody.graphics.drawRect(-10, -10, 485, 485);
            _flashBody.graphics.endFill();
            addChild(_flashBody);
            
            _scorer = new Scorer(this);
            _duration = 0;
            
            _flashBody.addEventListener(MouseEvent.CLICK, clickHandler);
            addEventListener(Event.ENTER_FRAME, shakeScreen);
        }
        
        private function clickHandler(event:MouseEvent):void {
            var damage:int = 10000 * Math.random();
            _scorer.update(damage);
            
            if (_tween) { _tween.stop(); }
            _tween = BetweenAS3.tween(
                _flashBody.transform,
                {colorTransform: { redOffset:0 }},
                {colorTransform: { redOffset:128 }},
                1,
                Expo.easeOut
            );
            _tween.play();
            _duration = 6;
            
            new ScoreIndicator(this, event.target.mouseX, event.target.mouseY, damage.toString());
        }
        
        private function shakeScreen(event:Event):void {
            _duration--;
            if (_duration <= 0) {
                x = y = 0;
            }else {
                x = int(5 * Math.random()) - 2;
                y = int(5 * Math.random()) - 2;
            }
        }
    }
}
// -----------------------------------------------------------------------------------------
// Scorer
// -----------------------------------------------------------------------------------------
//package {
    import com.bit101.components.InputText;
    import com.bit101.components.PushButton;
    import flash.display.DisplayObjectContainer;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import net.wonderfl.score.basic.BasicScoreRecordViewer;
    import net.wonderfl.score.form.ScoreForm;
    
    //public
    class Scorer extends ScoreForm {
        private var _max:int;
        private var _min:int;
        private var _maxText:TextField;
        private var _minText:TextField;
        private var _scoreText:TextField;
        
        private var _nameInput:InputText;
        private var _sendButton:PushButton;
        private var _errorText:TextField;
        
        private var _ranking:BasicScoreRecordViewer;
        
        public function Scorer(parent:DisplayObjectContainer, app_id:String = "", app_key:String = "") {
            graphics.beginFill(0x303030);
            graphics.drawRect(-10, -10, 485, 70);
            graphics.endFill();
            
            setup();
            initialize();
            
            super(_nameInput, 0, app_id, app_key);
            parent.addChild(this);
        }
        
        private function setup():void {
            var builder:TextBuilder = new TextBuilder();
            builder.align(TextBuilder.ALIGN_CENTER).font(Main.FONT, Main.EMBED, Main.EMBED);
            builder.fontColor(0xffffff).fontSize(12).size(100, 20);
            
            addChild(builder.position(10, 5).build("Max.dmg"));
            addChild(builder.position(130, 5).build("Min.dmg"));
            addChild(builder.position(250, 5).build("Score"));
            
            builder.bold().fontSize(14);
            addChild(_maxText = builder.position(10, 25).build("0"));
            addChild(_minText = builder.position(130, 25).build("0"));
            addChild(_scoreText = builder.position(250, 25).build("0"));
            
            builder.size(20, 20);
            addChild(builder.position(110, 25).build("-"));
            addChild(builder.position(230, 25).build("="));
            
            builder.align(TextBuilder.ALIGN_RIGHT).autoSize().bold(false).fontColor(0xff0000).fontSize(8).size(100, 20);
            addChild(_errorText = builder.position(360, 40).build(":-)"));
            
            _nameInput = new InputText(this, 360, 5);
            _sendButton = new PushButton(this, 360, 21, "Send Score", sendButtonHandler);
        }
        
        private function initialize():void {
            _max = 0;
            _min = int.MAX_VALUE;
            _maxText.text = _minText.text = _scoreText.text = "0";
        }
        
        private function sendButtonHandler(event:MouseEvent):void {
            _sendButton.enabled = false;
            _score = Math.max(0, _max - _min);
            _errorText.text = ":-)";
            sendScore();
        }
        
        override protected function onComplete():void {
            initialize();
            
            if (_ranking) { removeChild(_ranking); }
            var posX:int = (465 - BasicScoreRecordViewer.WIDTH) / 2;
            var posY:int = (465 - BasicScoreRecordViewer.HEIGHT) / 2;
            _ranking = new BasicScoreRecordViewer(this, posX, posY, "Ranking", 20, true, null, _app_id, _api_key);
            _sendButton.enabled = true;
        }
        
        override protected function onError(errorMassage:String):void {
            _errorText.text = errorMassage;
        }
        
        public function update(damage:int):void {
            if (damage > _max) { _max = damage; }
            if (damage < _min) { _min = damage; }
            _maxText.text = _max.toString();
            _minText.text = _min.toString();
            _scoreText.text = (_max - _min).toString();
        }
    }
//}
// -----------------------------------------------------------------------------------------
// ScoreIndicator
// -----------------------------------------------------------------------------------------
//package {
    import flash.display.DisplayObjectContainer;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    //public
    class ScoreIndicator extends Sprite {
        private var _chars:Vector.<TextField>;
        private var _charIndex:int;
        private var _numCompleted:int;
        
        public function ScoreIndicator(parent:DisplayObjectContainer, centerX:int, bottomY:int, text:String) {
            parent.addChild(this);
            x = centerX;
            y = bottomY;
            
            _chars = new Vector.<TextField>();
            _charIndex = 0;
            _numCompleted = 0;
            
            splitText(text);
            alignChars();
            playTween();
            
            addEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);
        }
        
        private function splitText(text:String):void {
            // 文字のスタイルを設定する
            var builder:TextBuilder = new TextBuilder();
            builder.autoCorrect(false).autoSize().bold();
            builder.font(Main.FONT, Main.EMBED).fontColor(0xffffff).fontSize(18);
            builder.textBorder(true, 0x404040, 2, 4);
            
            for (var i:int = 0; i < text.length; i++) {
                _chars.push(builder.build(text.charAt(i)));
            }
        }
        
        private function alignChars():void {
            var i:int, charsWidth:Number = 0;
            
            for (i = 0; i < _chars.length; i++) {
                charsWidth += _chars[i].textWidth;
            }
            
            if(_chars[0]){
                _chars[0].x = -int(charsWidth / 2);
                _chars[0].y = -_chars[0].textHeight;
            }
            
            for (i = 1; i < _chars.length; i++) {
                _chars[i].x = _chars[i - 1].x + _chars[i - 1].textWidth;
                _chars[i].y = -_chars[i].textHeight;
            }
        }
        
        private function playTween(event:Event = null):void {
            if (event) { removeEventListener(Event.ENTER_FRAME, playTween); }
            
            var char:TextField = _chars[_charIndex++];
            addChild(char);
            
            // 各文字に適用するトゥーイン
            var tween:ITween = BetweenAS3.bezierTo(char, { y: char.y }, { $y: -(char.textHeight * 2) }, 0.3, Sine.easeInOut);
            tween.onComplete = tweenCompleteHandler;
            tween.play();
            
            if (_charIndex < _chars.length) {
                addEventListener(Event.ENTER_FRAME, playTween);
            }
        }
        
        private function tweenCompleteHandler():void {
            _numCompleted++;
        }
        
        private function checkEveryTweenCompleted(event:Event):void {
            if (_numCompleted == _chars.length) {
                removeEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);
                BetweenAS3.serial(
                    BetweenAS3.to(this, { alpha: 0 }, 0.3, Expo.easeIn),
                    BetweenAS3.removeFromParent(this)
                ).play();
            }
        }
    }
//}
// -----------------------------------------------------------------------------------------
// TextBuilder
// -----------------------------------------------------------------------------------------
//package {
    import flash.filters.GlowFilter;
    import flash.text.AntiAliasType;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    //public
    class TextBuilder {
        public static const ALIGN_LEFT:String = "left";
        public static const ALIGN_RIGHT:String = "right";
        public static const ALIGN_CENTER:String = "center";
        
        private var _posX:Number;
        private var _posY:Number;
        
        private var _width:Number;
        private var _height:Number;
        
        private var _background:Boolean;
        private var _backgroundColor:uint;
        
        private var _border:Boolean;
        private var _borderColor:uint;
        
        private var _fontName:String;
        private var _embedFonts:Boolean;
        private var _advancedAntiAlias:Boolean;
        
        private var _fontSize:int;
        private var _fontColor:uint;
        private var _bold:Boolean;
        
        private var _textBorder:Boolean;
        private var _textBorderColor:uint;
        private var _textBorderBlur:Number;
        private var _textBorderStrength:Number;
        
        private var _align:String;
        private var _autoSizeEnabled:Boolean;
        private var _autoCorrectPositionY:Boolean;
        private var _wordWrap:Boolean;
        
        public function TextBuilder() {
            clear();
        }
        
        public function clear():TextBuilder {
            _posX = 0;
            _posY = 0;
            _width = 100;
            _height = 100;
            _background = false;
            _backgroundColor = 0xffffff;
            _border = false;
            _borderColor = 0x000000;
            _fontName = "Arial";
            _embedFonts = false;
            _advancedAntiAlias = false;
            _fontSize = 12;
            _fontColor = 0x000000;
            _bold = false;
            _textBorder = false;
            _textBorderColor = 0xffff00;
            _textBorderBlur = 4;
            _textBorderStrength = 2;
            _align = TextBuilder.ALIGN_LEFT;
            _autoSizeEnabled = false;
            _autoCorrectPositionY = true;
            _wordWrap = false;
            return this;
        }
        
        public function position(x:Number, y:Number):TextBuilder {
            _posX = x;
            _posY = y;
            return this;
        }
        
        public function size(width:Number, height:Number):TextBuilder {
            _width = width;
            _height = height;
            return this;
        }
        
        public function background(enabled:Boolean, color:uint = 0xffffff):TextBuilder {
            _background = enabled;
            _backgroundColor = color;
            return this;
        }
        
        public function border(enabled:Boolean, color:uint = 0x000000):TextBuilder {
            _border = enabled;
            _borderColor = color;
            return this;
        }
        
        public function font(name:String, embed:Boolean = false, advancedAntiAlias:Boolean = false):TextBuilder {
            _fontName = name;
            _embedFonts = embed;
            _advancedAntiAlias = advancedAntiAlias;
            return this;
        }
        
        public function fontSize(size:int):TextBuilder {
            _fontSize = size;
            return this;
        }
        
        public function fontColor(color:uint):TextBuilder {
            _fontColor = color;
            return this;
        }
        
        public function bold(enabled:Boolean = true):TextBuilder {
            _bold = enabled;
            return this;
        }
        
        public function textBorder(enabled:Boolean, color:uint = 0xffff00, blur:Number = 4, strength:Number = 2):TextBuilder {
            _textBorder = enabled;
            _textBorderColor = color;
            _textBorderBlur = blur;
            _textBorderStrength = strength;
            return this;
        }
        
        public function align(value:String = TextBuilder.ALIGN_LEFT):TextBuilder {
            _align = value;
            return this;
        }
        
        public function autoSize(enabled:Boolean = true):TextBuilder {
            _autoSizeEnabled = enabled;
            return this;
        }
        
        public function autoCorrect(positionY:Boolean = true):TextBuilder {
            _autoCorrectPositionY = positionY;
            return this;
        }
        
        public function wordWrap(enabled:Boolean = true):TextBuilder {
            _wordWrap = enabled;
            return this;
        }
        
        public function build(text:String):TextField {
            var textField:TextField = new TextField();
            
            textField.x = _posX;
            textField.y = _posY;
            textField.width = _width;
            textField.height = _height;
            
            var format:TextFormat = new TextFormat(_fontName, _fontSize, _fontColor, _bold);
            if (_autoSizeEnabled) {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { textField.autoSize = TextFieldAutoSize.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { textField.autoSize = TextFieldAutoSize.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { textField.autoSize = TextFieldAutoSize.CENTER; break; }
                }
            }else {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { format.align = TextFormatAlign.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { format.align = TextFormatAlign.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { format.align = TextFormatAlign.CENTER; break; }
                }
            }
            
            textField.embedFonts = _embedFonts;
            textField.antiAliasType = (_advancedAntiAlias ? AntiAliasType.ADVANCED : AntiAliasType.NORMAL);
            textField.defaultTextFormat = format;
            textField.text = text;
            
            if (textField.background = _background) { textField.backgroundColor = _backgroundColor; }
            if (textField.border = _border) { textField.borderColor = _borderColor; }
            if (_textBorder) { textField.filters = [new GlowFilter(_textBorderColor, 1, _textBorderBlur, _textBorderBlur, _textBorderStrength)]; }
            if (!(textField.wordWrap = _wordWrap) && _autoCorrectPositionY) { textField.y += Math.max(0, Math.ceil((_height - (textField.textHeight + 4)) / 2)); }
            textField.mouseEnabled = textField.selectable = false;
            
            return textField;
        }
        
        public function clone():TextBuilder {
            var clone:TextBuilder = new TextBuilder();
            clone._posX = _posX;
            clone._posY = _posY;
            clone._width = _width;
            clone._height = _height;
            clone._background = _background;
            clone._backgroundColor = _backgroundColor;
            clone._border = _border;
            clone._borderColor = _borderColor;
            clone._fontName = _fontName;
            clone._embedFonts = _embedFonts;
            clone._advancedAntiAlias = _advancedAntiAlias;
            clone._fontSize = _fontSize;
            clone._fontColor = _fontColor;
            clone._bold = _bold;
            clone._textBorder = _textBorder;
            clone._textBorderColor = _textBorderColor;
            clone._textBorderBlur = _textBorderBlur;
            clone._textBorderStrength = _textBorderStrength;
            clone._align = _align;
            clone._autoSizeEnabled = _autoSizeEnabled;
            clone._autoCorrectPositionY = _autoCorrectPositionY;
            clone._wordWrap = _wordWrap;
            return clone;
        }
    }
//}